<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Measurement_unit;
use Illuminate\Http\Request;

class Measurement_unitController extends Controller
{
    // public function check_role_permission()
    // {
    //     $get_role_id = auth()->user()->role_id;
    //     $noti_create_inquiry = role_permission::where('role_id', $get_role_id)->where('menu_id', 103)->first();
    //     $noti_create_quotation = role_permission::where('role_id', $get_role_id)->where('menu_id', 103)->first();
    //     if ($noti_create_inquiry) {
    //         $noti_array[] = 'self_inquiry';
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "create_quotation";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "send_quotation_to_approval";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "inquiry_remarks";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "quotation_remarks";
    //     } else {
    //         $noti_array = [];
    //     }
    //     return  $noti_array;
    // }

    public function index()
    {
        $measurement = Measurement_unit::all();
        return view('Measurement_Unit.index', compact('measurement'));
    }
    public function create()
    {
        $measurement = Measurement_unit::all();
        return view('Measurement_Unit.create', compact('measurement'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'measurement_unit_name' => 'required|string|max:255',
            'measurement_unit_status' => 'required|int:0,1',
        ]);

        $store = new Measurement_unit();
        $store->measurement_unit_name = $validated['measurement_unit_name'];
        $store->measurement_unit_status = $validated['measurement_unit_status'];
        // dd($store);
        $store->save();
        session()->flash('success', "New Measurement Unit Added Successfully");

        return redirect('measurement_unit');
    }

    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = Measurement_unit::where('id_measurement_unit', $dec_id)->first();

        return view('Measurement_Unit.edit', compact('edit'));
    }

    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        $update = Measurement_unit::where('id_measurement_unit', $dec_id)->first();
        $update->measurement_unit_name = $request->measurement_unit_name;
        $update->measurement_unit_status = $request->measurement_unit_status;
        $update->save();
        // dd($ update);


        session()->flash('info', "Measurement Unit Updated Successfully");
        return redirect('measurement_unit');
    }
    public function destroy($id)
    {

        $Measurement_unit = Measurement_unit::findOrFail($id);
        $Measurement_unit->delete();
        session()->flash('warning', "Measurement Unit Removed!");
        return redirect()->back();
    }
}
