@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Control Account</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <h2 class="az-content-title" style="display: inline">Control Account List</h2>
        <span>
            @can('Control Account add')
                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fas fa-plus"></i>Add Account
                </button>
            @endcan
        </span>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Account #</th>
                            <th class="wd-10p">Account Name</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- {{dd($main_account)}} --}}
                        @foreach ($control_account as $key => $m_acc)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $m_acc->control_account_number }}</td>
                                <td>{{ $m_acc->control_account_name }}</td>
                                <td>{{ $m_acc->created_at }}</td>
                                <td>
                                    @can('Sub Control Account list')
                                        <a class="btn btn-az-primary"
                                            href="{{ url('sub_control_account/' . $main_account->id_main_account . '/' . $m_acc->id_control_account) }}">

                                            Sub Control Account
                                        </a>
                                    @endcan
                                    @can('Control Account edit')
                                        <a type="button" class="btn " style="background-color: #ffb136; color: white"
                                            data-toggle="modal" data-target="#exampleModal2"
                                            data-id="{{ $m_acc->id_control_account }}"
                                            data-name="{{ $m_acc->control_account_name }}">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Account #</th>
                            <th class="wd-10p">Account Name</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('control_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_main_account" name="id_main_account"
                                value="{{ $main_account->id_main_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Sub Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_control_account" name="id_control_account"
                                value="{{ $main_account->id_main_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script type="text/javascript">
        $('#exampleModal2').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Button that triggered the modal
            var id = button.data('id'); // Extract info from data-* attributes
            var name = button.data('name');

            var modal = $(this);
            modal.find('#editForm').attr('action', '{{ url('control_account/update') }}/' + id);
            modal.find('#name').val(name);
        });

        $(function() {



            oTable = $('#example2').DataTable({

                responsive: !0
            });



        });
    </script>
@endpush
