@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Main Account</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <h2 class="az-content-title" style="display: inline">Main Account List</h2>
        <span>
            @can('Chart of Account list')
                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fas fa-plus"></i>
                    Add Account
                </button>
            @endcan
        </span>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">Account #</th>
                            <th class="wd-20p">Account Name</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($main_account as $key => $m_acc)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $m_acc->main_account_number }}</td>
                                <td>{{ $m_acc->main_account_name }}</td>
                                <td>{{ $m_acc->created_at }}</td>
                                <td>
                                    @can('Control Account list')
                                        <a class="btn btn-az-primary"
                                            href="{{ url('control_account/' . $m_acc->id_main_account) }}">
                                            Control account
                                        </a>
                                    @endcan 
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">Account #</th>
                            <th class="wd-20p">Account Name</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Main Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('main_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script type="text/javascript">
        // $(function(){
        //     $('#example2').DataTable({
        //         responsive: true
        //     });

        //     $('#addMainAccountForm').on('submit', function(e) {
        //         e.preventDefault();
        //         // Add your form submission logic here
        //         alert('Form submitted!');
        //         $('#exampleModal').modal('hide');
        //     });
        // });
        $(function() {



            oTable = $('#example2').DataTable({

                responsive: !0
            });



        });
    </script>
@endpush
