@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employee</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Employees List <span>
            @can('Employees add')
                <a href="{{ url('employee/create') }}" class="btn btn-az-primary" style="float: right">Add Employee</a>
            @endcan
        </span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            {{-- <div class="card card-body pd-40"> --}}

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Name</th>
                            <th class="wd-10p">Number</th>
                            <th class="wd-10p">Email</th>
                            <th class="wd-10p">Address</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created At</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employee as $key => $curr)
                            @php
                                $username = App\User::where('id', $curr->employee_created_by)->first();
                            @endphp
                            <tr>

                                <td>{{ $key + 1 }}</td>
                                <td>{{ $curr['employee_name'] }}</td>
                                <td>{{ $curr['employee_no'] }}</td>
                                <td>{{ $curr['employee_email'] }}</td>
                                <td>{{ $curr['employee_address'] }}</td>
                                <td>
                                    @if ($curr->status == 1)
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    @else
                                        <span class="btn btn-rounded btn-danger">In Active</span>
                                    @endif
                                </td>
                                <td>{{ $username->name }}</td>
                                <td><?= date('d-m-Y', strtotime($curr['created_at'])) ?></td>
                                <td>
                                    @can('Employees edit')
                                        <a class="btn btn-primary"
                                            href="{{ url('employee/edit/' . \Crypt::encrypt($curr['id_employee'])) }}">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    @endcan
                                    @can('Employees delete')
                                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                            data-id="{{ $curr->id_employee }}">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Name</th>
                            <th class="wd-10p">Number</th>
                            <th class="wd-10p">Email</th>
                            <th class="wd-10p">Address</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created At</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            {{-- </div> --}}
            <!-- card -->
        </div>
        <!-- col -->
    </div>


    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Employee?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>





    {{-- </div><!-- az-content-body --> --}}
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('employee/delete') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
