@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Discounts</span>
        <span>Add Discount</span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Discounts <span><a href="{{ url('discounts') }}"
                class="btn btn-az-primary" style="float: right">Discounts List</a></span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Discounts</h5>
                <form method="post" action="{{url('discounts/store')}}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                @endforeach
                        </div>
                        @endif

                        <div class="row row-sm mg-b-20">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Discounts Name</label>
                                    <input type="text" name="discount_name" class="form-control" required />
                                </div>
                            </div>



                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Discounts Type</label>
                                    <input type="text" name="discount_type" class="form-control" required />
                                </div>
                            </div>

                        </div>
                        <div class="row row-sm mg-b-20">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Discount For</label>
                                    <input type="text" name="discount_for" class="form-control" required />
                                </div>
                            </div>



                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Discount</label>
                                    <input type="text" name="discount_price" class="form-control" required />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                                <select class="form-control" name="discount_status" id="discount_status">
                                    <option value="1">Active</option>
                                    <option value="0">In Active</option>
                                </select>
                            </div>

                        </div>
                        {{-- <div class="row row-sm mg-b-20">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                                    <input type="text" name="status" class="form-control" required />
                                </div>
                            </div>

                        </div>


                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Created By</label>
                                    <input type="text" name="created_by" class="form-control" required />
                                </div>
                            </div>

                        </div> --}}

                    <a type="button" href="{{ url('/discounts') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


@endsection
