@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span> Service Purchase </span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Service Purchase List <span>
            @can('Service Purchase add')
                <a href="{{ route('service_purchase.create') }}" class="btn btn-az-primary" style="float: right"><i
                        class="fa-solid fa-plus"></i> Add New Service Purchase </a></span>
        @endcan
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">

                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Sp No</th>
                                <th class="wd-10p">Vechile No</th>
                                <th class="wd-10p">Bill No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="wd-10p">Expense</th>
                                <th class="wd-10p">Qty</th>
                                {{-- <th class="wd-10p">Unit</th> --}}
                                <th class="wd-10p">Amount</th>
                                {{-- <th class="wd-10p">Remarks</th> --}}
                                <th class="wd-10p">Created By</th>
                                {{-- <th class="wd-10p">Created At</th> --}}
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($service as $key => $service)
                            @php
                            $username = App\User::where('id', $service->created_by)->first();
                           @endphp
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    {{-- <td>{{ $service->unit_id }}</td> --}}
                                    <td>{{ $service->ser_purchase_sp_no }}</td>
                                    <td>{{ $service->ser_purchase_vechile_no }}</td>
                                    <td>{{ $service->ser_purchase_bill_no }}</td>
                                    <td>{{ $service->supplier_id }}</td>
                                    <td>{{ $service->ser_purchase_expense }}</td>
                                    <td>{{ $service->ser_purchase_qty }}</td>
                                    {{-- <td>{{ $service->ser_purchase_unit }}</td> --}}
                                    {{-- <td>{{ $service->ser_purchase_price }}</td> --}}
                                    <td>{{ $service->ser_purchase_amount }}</td>
                                    {{-- <td>{{ $service->ser_purchase_remarks }}</td> --}}
                                    <td>{{ $service->created_by }}</td>
                                    <td>
                                        @if ($service->ser_purchase_status == 1)
                                            <button class="btn btn-rounded btn-success" style="color:#fff;">
                                                <strong>Active</strong> <span class="badge badge-primary"></span>
                                            </button>
                                        @else
                                            <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                                <i class="fa-solid fa-ban"></i> <strong>Deactivated</strong> <span
                                                    class="badge badge-primary"></span>
                                            </button>
                                        @endif
                                    </td>
                                    <td>
                                        @can('Service Purchase edit')
                                         <a class="btn btn-rounded" href="{{ route('service_purchase.edit', Crypt::encrypt($service->id_ser_purchase)) }}">
                                             <i class="text-primary fa-regular fa-pen-to-square"></i>
                                         </a>
                                        @endcan
                                        @can('Service Purchase delete')
                                        <a class="btn btn-rounded"
                                            href="{{ route('service_purchase.destroy', ['id' => Crypt::encrypt($service->id_ser_purchase)]) }}">
                                            <i class="text-danger fa-solid fa-trash-can"></i>
                                        </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Sp No</th>
                                <th class="wd-10p">Vechile No</th>
                                <th class="wd-10p">Bill No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="wd-10p">Expense</th>
                                <th class="wd-10p">Qty</th>
                                {{-- <th class="wd-10p">Unit</th> --}}
                                <th class="wd-10p">Amount</th>
                                {{-- <th class="wd-10p">Remarks</th> --}}
                                <th class="wd-10p">Created By</th>
                                {{-- <th class="wd-10p">Created At</th> --}}
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
@endpush
