@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Stock</span>
        <span>Add Stock</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add Product Stock
        <span>
            <a href="{{ route('products.stock.list', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product->id_products)]) }}"
                class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Stock
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Add Stock Details</h5>

                    @if (Session::has('alert'))
                        <div class="alert alert-card alert-{{ Session::get('alert-class') }}" role="alert">
                            {{ Session::get('alert') }}
                            <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <form action="{{ route('products.stocks.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="products_id" value="{{ $product->id_products }}">
                        <input type="hidden" name="brand_id" value="{{ $product->brands_id }}">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name</label>
                                    <input type="text" class="form-control" value="{{ $product->products_name }}"
                                        disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Select Store</label>
                                    <select name="store_id" id="store_id" class="form-control">
                                        <option value="">Select Store</option>
                                        @foreach ($stores as $store)
                                            <option value="{{ $store->id_store }}">{{ $store->store_name }}</option>
                                        @endforeach
                                    </select>
                                    @error('store_id')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Number</label>
                                    <input type="text" class="form-control" name="stock_batch_number"
                                        value="{{ old('stock_batch_number') }}">
                                    @error('stock_batch_number')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Purchased Qty</label>
                                    <input type="number" class="form-control" name="stock_purchase_qty"
                                        value="{{ old('stock_purchase_qty') }}" required>
                                    @error('stock_purchase_qty')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Purchase Date</label>
                                    <input type="date" class="form-control" name="stock_purchase_date"
                                        value="{{ old('stock_purchase_date') }}" required>
                                    @error('stock_purchase_date')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Expiry Date</label>
                                    <input type="date" class="form-control" name="stock_expiry_date"
                                        value="{{ old('stock_expiry_date') }}" required>
                                    @error('stock_expiry_date')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>  
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Purchase Price</label>
                                    <input type="text" class="form-control" name="stock_purchase_price"
                                        value="{{ $product->products_purchase_price }}">
                                    @error('stock_purchase_price')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="stock_status">Status</label>
                                    <select id="stock_status" name="stock_status" class="form-control">
                                        <option value="">Select</option>
                                        <option value="1" {{ old('stock_status') == '1' ? 'selected' : '' }}>Active
                                        </option>
                                        <option value="0" {{ old('stock_status') == '0' ? 'selected' : '' }}>
                                            In-Active
                                        </option>
                                    </select>
                                    @error('stock_status')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Remarks</label>
                                <textarea class="form-control" name="stock_remarks"
                                    rows="3">{{ old('stock_remarks') }}</textarea>
                                @error('stock_remarks')
                                    <span class="form-text text-danger">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <button type="submit" class="btn btn-az-primary btn-block mt-2 float-end"><i class="fa-regular fa-floppy-disk"></i> <strong>Save</strong></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
