

<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Brands</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Brands List <span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Brands add')): ?>
                <a href="<?php echo e(route('brands.create')); ?>" class="btn btn-az-primary" style="float: right"><i
                        class="fa-solid fa-plus"></i>Add New Brand</a></span>
        <?php endif; ?>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">

                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                if (!empty($brand->brands_logo)) {
                                    $image = url('/uploads/brand_images/' . $brand->brands_logo);
                                } else {
                                    $image = url('/img/default_user.png');
                                }
                                ?>
                                <tr>

                                    <td><?php echo e($key + 1); ?></td>
                                    <td>
                                        <img src="<?= $image ?>" style="height:40px;width:40px;border-radius: 50%"
                                            alt="" srcset="">
                                    </td>
                                    <td><?php echo e($brand->brands_name); ?></td>
                                    <td><?php echo e($brand->brands_abbrevation); ?></td>
                                    <td><?php echo e($brand->created_by); ?></td>
                                    <td><?= date('d-m-Y', strtotime($brand->created_at)) ?></td>
                                    <td>
                                        <?php if($brand->brands_status == 1): ?>
                                            <button class="btn btn-rounded btn-success" style="color:#fff;">
                                                <strong>Active</strong> <span class="badge badge-primary"></span>
                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                                <i class="fa-solid fa-ban"></i> <strong>Deactivated</strong> <span
                                                    class="badge badge-primary"></span>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Products list')): ?>
                                            <a class="btn btn-rounded text-info"
                                                href="<?php echo e(route('products.list', Crypt::encrypt($brand->id_brands))); ?>">
                                                <i class="fa-solid fa-arrow-up-right-from-square"></i> <strong>Products</strong>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Brands edit')): ?>
                                            <a class="btn btn-rounded"
                                                href="<?php echo e(route('brand.edit', Crypt::encrypt($brand->id_brands))); ?>">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Brands delete')): ?>
                                        <a class="btn btn-rounded"
                                            href="<?php echo e(route('brand.destroy', ['id' => Crypt::encrypt($brand->id_brands)])); ?>">
                                            <i class="text-danger fa-solid fa-trash-can"></i>
                                        </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/brands/index.blade.php ENDPATH**/ ?>