
<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Measurement Unit</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Measurement Unit List <span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Measurement Units add')): ?>
                <a href="<?php echo e(url('measurement_unit/create')); ?>" class="btn btn-az-primary" style="float: right">Add Measurement
                    Unit</a>
            <?php endif; ?>
        </span></h2>
    


    
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">Unit Name</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $measurement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $curr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>

                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($curr['measurement_unit_name']); ?></td>
                                <td>
                                    <?php if($curr['measurement_unit_status'] == 1): ?>
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    <?php else: ?>
                                        <span class="btn btn-rounded btn-danger">In Active</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d-m-Y', strtotime($curr['created_at'])) ?></td>

                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Measurement Units edit')): ?>
                                        <a class="btn btn-primary"
                                            href="<?php echo e(url('measurement_unit/edit/' . \Crypt::encrypt($curr['id_measurement_unit']))); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Measurement Units delete')): ?>
                                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                            data-id="<?php echo e($curr->id_measurement_unit); ?>">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">Unit Name</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </tfoot>
                </table>

                <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                Are you sure you want to delete this Measurement Unit?
                            </div>
                            <div class="modal-footer">
                                <form id="deleteForm" action="" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-danger">Delete</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            
            <!-- card -->
        </div>
        <!-- col -->
    </div>






    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '<?php echo e(url('measurement_unit/delete')); ?>/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/Measurement_Unit/index.blade.php ENDPATH**/ ?>