
<?php $__env->startSection('content'); ?>
<div class="card card-body pd-10">
    <div class="az-content-breadcrumb">
        <span>Users</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Users List <span>
            <a href="<?php echo e(url('users/create')); ?>" class="btn btn-az-primary" style="float: right">Add User</a></span></h2>
    

    </div>
    
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40"> 

            <div>
                <table id="example2" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">User Name</th>
                            <th class="wd-15p">User Role</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Updated</th>
                            <th class="wd-10p">Operations</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $my_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                            <tr>

                                <td><?php echo e($my_user['id']); ?></td>
                                <td><?php echo e($my_user['name']); ?></td>
                                <td><?php echo e($my_user['role_name']); ?></td>
                                <td>
                                    <?php if($my_user['status'] == 1): ?>
                                    <button class="btn btn-rounded btn-success" style="color:#fff;">
                                            Active <span class="badge badge-primary"></span>
                                        </button>
                                    <?php else: ?>
                                    <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                            Deactive <span class="badge badge-primary"></span>
                                        </button>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d-m-Y', strtotime($my_user['created_at']))?></td>
                                <td><?= date('d-m-Y', strtotime($my_user['updated_at']))?></td>
                                <td><a class="btn btn-rounded btn-primary" href="<?php echo e(url('users/edit/' . Crypt::encrypt($my_user['id']))); ?>">
                                Edit
                                </a> 
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                     <tfoot>
                         <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">User Name</th>
                            <th class="wd-15p">User Role</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Updated</th>
                            <th class="wd-10p">Operations</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
             </div> 
            <!-- card -->
        </div>
        <!-- col -->
    </div>






    
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('#example2 tfoot th').each(function () {
        var title = $(this).text();
        $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
    });

            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control'
                }],
            initComplete: function () {
            // Apply the search
            this.api()
                .columns()
                .every(function () {
                    var that = this;

                    $('input', this.footer()).on('keyup change clear', function () {
                        if (that.search() !== this.value) {
                            that.search(this.value).draw();
                        }
                    });
                });
        }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Travocom\TVC_PHASE_1\resources\views/Users/index.blade.php ENDPATH**/ ?>