

<?php
    $units = App\Measurement_unit::where('id_measurement_unit', $product->measurement_unit_id)->first();
?>

<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Products Stock</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Stock List
        <span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Stocks add')): ?>
                <a href="<?php echo e(route('products.stocks.create', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product_id)])); ?>"
                    class="btn btn-az-primary" style="float: right"><i class="fa-solid fa-plus"></i> Add New Stock</a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Products list')): ?>
                <a href="<?php echo e(route('products.list', Crypt::encrypt($product->brands_id))); ?>" class="btn border"
                    style="float: right">
                    <i class="fa-solid fa-bars-staggered"></i> Back to Products
                </a>
            <?php endif; ?>
        </span>
    </h2>
    <div class="row my-3">
        <div class="col-md-6 col-lg-6 col-xl-6">
            <div class="profile-card bg-light shadow rounded p-4">
                <section id="personal-info">
                    <h2 class="mb-4" style="color: #00beda;">Product Information</h2>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Product Name:</label>
                            <span><strong><?php echo e($product->products_name); ?></strong></span>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Price:</label>
                            <strong><?php echo e($product->products_sale_price); ?></strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Unit:</label>
                            <strong><?php echo e($units ? $units->measurement_unit_name : 'N/A'); ?></strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Overall Stock:</label>
                            <strong><?php echo e($product->in_stock ? $product->in_stock : '0'); ?></strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Brand Name:</label>
                            <strong><?php echo e($product->brand->brands_name); ?></strong>
                        </h5>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Store Name</th>
                                <th class="wd-10p">Batches#</th>
                                <th class="wd-10p">Pur. Date</th>
                                <th class="wd-10p">Expires</th>
                                <th class="wd-10p">Purchase Qty</th>
                                <th class="none">Customer Return</th>
                                <th class="wd-10p">Transfer In</th>
                                <th class="wd-10p">Transfer Out</th>
                                <th class="wd-10p">Sold</th>
                                <th class="none">Supplier Return</th>
                                <th class="none">Damage</th>
                                <th class="none">Remain Qty</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $color = $product->products_status == 0 ? '#f5c5c5' : '';
                            ?>
                            <?php $__currentLoopData = $product->stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="background-color: <?php echo e($color); ?>;">
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e(optional($stock->store)->store_name ?? 'N/A'); ?></td>
                                    <td><?php echo e($stock->stock_batch_number ?? 'N/A'); ?></td>
                                    <td><?php echo e(date('d-m-Y', strtotime($stock->stock_purchase_date)) ?? 'N/A'); ?></td>
                                    <td><?php echo e(date('d-m-Y', strtotime($stock->stock_expiry_date)) ?? 'N/A'); ?></td>
                                    <td><?php echo e($stock->stock_purchase_qty ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_customer_return ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_qty_to_transfer_in ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_qty_to_transfer_out ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_sold_qty ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_supplier_return ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_damage_qty ?? '0'); ?></td>
                                    <td><?php echo e($stock->stock_remain_qty ?? '0'); ?></td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Stocks edit')): ?>
                                            <a class="btn rounded shadow-base" title="Edit Stock"
                                                href="<?php echo e(route('products.stocks.edit', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)])); ?>">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                    class="text-primary">Edit</span>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Stocks increase')): ?>
                                            <a class="btn rounded shadow-base" title="Add More Stock Quantity"
                                                href="<?php echo e(route('products.stocks.increase', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)])); ?>">
                                                <i class="text-info fa-solid fa-plus"></i> <span class="text-info">Increase
                                                    Stock</span>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Stocks transfer')): ?>
                                            <a class="btn rounded shadow-base" title="Stock Transfer"
                                                href="<?php echo e(route('products.stocks.edit', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)])); ?>">
                                                <i class="text-muted fa-solid fa-right-left"></i> <span
                                                    class="text-muted">Transfer</span>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Stocks damage')): ?>
                                            <a class="btn rounded shadow-base" title="Remove the stock"
                                                href="<?php echo e(route('products.stocks.damage', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)])); ?>">
                                                <img src="<?php echo e(asset('stock-damaged.png')); ?>" alt="Add Damaged Stock"
                                                    style="height: 18px; width: auto; margin-bottom: 4px;"> <span
                                                    class="text-danger">Damage</span>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Store Name</th>
                                <th class="wd-10p">Batches#</th>
                                <th class="wd-10p">Pur. Date</th>
                                <th class="wd-10p">Expires</th>
                                <th class="wd-10p">Purchase Qty</th>
                                <th class="none">Customer Return</th>
                                <th class="wd-10p">Transfer In</th>
                                <th class="wd-10p">Transfer Out</th>
                                <th class="wd-10p">Sold</th>
                                <th class="none">Supplier Return</th>
                                <th class="none">Damage</th>
                                <th class="none">Remain Qty</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: true,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/stock/index.blade.php ENDPATH**/ ?>