

<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Stock</span>
        <span>Increase Stock</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Increase Product Stock
        <span>
            <a href="<?php echo e(route('products.stock.list', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product->id_products)])); ?>"
                class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Stock
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Increase Stock Details</h5>

                    <?php if(Session::has('alert')): ?>
                        <div class="alert alert-card alert-<?php echo e(Session::get('alert-class')); ?>" role="alert">
                            <?php echo e(Session::get('alert')); ?>

                            <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <form
                        action="<?php echo e(route('products.stocks.increase', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)])); ?>"
                        method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name</label>
                                    <input type="text" class="form-control" value="<?php echo e($product->products_name); ?>"
                                        disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Number</label>
                                    <input type="text" class="form-control" value="<?php echo e($stock->stock_batch_number); ?>"
                                        disabled>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Date</label>
                                    <input type="date" class="form-control" value="<?php echo e($stock->stock_purchase_date); ?>"
                                        disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Expiry Date</label>
                                    <input type="date" class="form-control" value="<?php echo e($stock->stock_expiry_date); ?>"
                                        disabled>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Type</label>
                                    <select name="stock_type" class="form-control" required>
                                        <option value="">Select</option>
                                        <option value="increase">Increase Stock</option>
                                        <option value="reverse">Reverse Stock</option>
                                    </select>
                                    <?php $__errorArgs = ['stock_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="form-text text-danger">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Add or Remove</label>
                                    <input type="number" class="form-control" name="stock_purchase_qty" required>
                                    <?php $__errorArgs = ['stock_purchase_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="form-text text-danger">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Remarks</label>
                                <textarea class="form-control" name="stock_remarks" rows="3"></textarea>
                                <?php $__errorArgs = ['stock_remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="form-text text-danger">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-az-primary btn-block mt-2 float-end"><i
                                class="fa-regular fa-floppy-disk"></i> <strong>Save</strong></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/stocks/increase.blade.php ENDPATH**/ ?>