
<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Customers</span>
        
        
        
    </div>
    <h2 class="az-content-title" style="display: inline"> Customers List <span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Customers add')): ?>
                <a href="<?php echo e(url('customers/create')); ?>" class="btn btn-az-primary" style="float: right">Add Customers</a></span>
        <?php endif; ?>
    </h2>
    


    
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">

                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-2">S.No</th>
                                <th class="wd-2">IM</th>
                                <th class="wd-20p">Customer Name</th>
                                <th class="wd-15p">Number</th>
                                <th class="wd-15p">Customer Other / PTCL / WHATSAPP</th>
                                <th class="wd-15p">Customer Email</th>
                                <th class="wd-15p ">Customer Address </th>
                                <th class="none ">Created</th>
                                <th class="none ">Updated</th>
                                <th class="none">Operations</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                if (!empty($hotel['customer_image'])) {
                                    $image = url('/uploads/customer_images/' . $hotel['customer_image']);
                                } else {
                                    $image = url('/img/default_user.png');
                                }
                                $sale_person = \App\User::select('users.name')
                                    ->where('id', '=', $cus->sale_person)
                                    ->first();
                                $whatsapp_enabled = '';
                                if ($cus->whatsapp_check == 1) {
                                    $whatsapp_enabled = '<img src="img/whatsapp.png" style="height:20px;width:20px;border-radius: 50%" alt="" srcset="">';
                                }
                                ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><img src="<?= $image ?>" style="height:20px;width:20px;border-radius: 50%"
                                            alt="" srcset=""></td>
                                    <td><?php echo e($cus->customer_name); ?></td>
                                    <td><?php echo e($cus->customer_phone1); ?></td>
                                    <td><?php echo e($cus->customer_phone2); ?></td>
                                    <td><?php echo e($cus->customer_email); ?></td>
                                    <td><?php echo e($cus->customer_address); ?></td>


                                    <td><?= date('d-m-Y', strtotime($cus->created_at)) ?></td>
                                    <td><?= date('d-m-Y', strtotime($cus->updated_at)) ?></td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Customers edit')): ?>
                                            <a class="btn btn-rounded btn-primary"
                                                href="<?php echo e(url('customers/edit/' . Crypt::encrypt($cus->id_customers))); ?>">
                                                Edit
                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Customers delete')): ?>
                                            <a class="btn btn-rounded btn-danger"
                                                href="<?php echo e(url('customers/destroy/' . Crypt::encrypt($cus->id_customers))); ?>">
                                                Delete
                                            </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Customers view')): ?>
                                        <a class="btn btn-rounded btn-success" style="color:#fff;"
                                                href="<?php echo e(url('customers/view/' . Crypt::encrypt($cus->id_customers))); ?>">
                                                Summary
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">IM</th>
                                <th class="wd-20p">Customer Name</th>
                                <th class="wd-15p">Number</th>
                                <th class="wd-15p">Customer Other / PTCL / WHATSAPP</th>
                                <th class="wd-15p">Customer Email</th>
                                <th class="wd-15p ">Customer Address </th>
                                <th class="none">Created</th>
                                <th class="none ">Updated</th>
                                <th class="none ">Operations</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>






    
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });

            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false,
                    targets: 0
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;

                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/customers/index.blade.php ENDPATH**/ ?>