

<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<style>
    .dot {
        height: 10px;
        width: 10px;
        background-color: #ef8e8e;
        border-radius: 50%;
        display: inline-block;
    }

    .dot2 {
        height: 10px;
        width: 10px;
        background-color: #b69595;
        border-radius: 50%;
        display: inline-block;
    }

    .module-header {
        font-weight: bold;
    }
</style>

<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Roles Permission Management</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Roles List </h2>

    <div class="row">
        <div class="col-md-12">
            <?php if(Session('alert')): ?>
                <div class="alert alert-card alert-<?php echo e(Session('alert-class')); ?>" role="alert">
                    <?php echo e(Session('alert')); ?>

                    <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <label for="role">Role</label>
            <select onchange="location.href='<?php echo e(url('roles/permission')); ?>/' + this.value;" class="form-control">
                <option value="0">--Select--</option>
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($role->id); ?>" <?php echo e($role_id == $role->id ? 'selected' : ''); ?>><?php echo e($role->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row mb-4">
        <div class="col-md-12 mb-3">
            <div class="card text-left">
                <div class="card-body">
                    <h4 class="card-title mb-3">List</h4>
                    <h6 class="card-title mb-3"><span for="check-al">Check All </span><input type="checkbox"
                            class="check-module" id="check-all"></h6>
                    <form action="<?php echo e(url('roles/permission', [$role_id])); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="table-responsive">
                            <table id="permissionsTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Pages</th>
                                        <th>Permission</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    <?php $__currentLoopData = $permissions->groupBy('parent_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent_id => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($parent_id == 0): ?>
                                            <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="odd gradeX">
                                                    <td><?php echo e($count++); ?></td>
                                                    <td>
                                                        <label>
                                                            <input type="checkbox" class="check-module" name="permissions[]"
                                                                value="<?php echo e($permission->id); ?>"
                                                                <?php echo e(in_array($permission->id, $assigned_permissions) ? 'checked' : ''); ?>>
                                                            <strong><?php echo e($permission->name); ?></strong>
                                                        </label>
                                                    </td>
                                                    <td></td>
                                                </tr>
                                                <?php $__currentLoopData = $permissions->where('parent_id', $permission->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subPermission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="odd gradeX sub-module" data-parent="<?php echo e($permission->id); ?>">
                                                        <td><?php echo e($count++); ?></td>
                                                        <td style="padding-left: 3rem;">
                                                            <label>
                                                                <input type="checkbox" class="check-submodule"
                                                                    name="permissions[]" value="<?php echo e($subPermission->id); ?>"
                                                                    <?php echo e(in_array($subPermission->id, $assigned_permissions) ? 'checked' : ''); ?>>
                                                                <span class="dot"></span> <?php echo e($subPermission->name); ?>

                                                            </label>
                                                        </td>
                                                        <td></td>
                                                    </tr>
                                                    <?php $__currentLoopData = $permissions->where('parent_id', $subPermission->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSubPermission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr class="odd gradeX sub-permissions"
                                                            data-parent="<?php echo e($subPermission->id); ?>">
                                                            <td><?php echo e($count++); ?></td>
                                                            <td style="padding-left: 5rem;">
                                                                <span class="dot2"></span> <?php echo e($subSubPermission->name); ?>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="permissions[]"
                                                                    value="<?php echo e($subSubPermission->id); ?>"
                                                                    <?php echo e(in_array($subSubPermission->id, $assigned_permissions) ? 'checked' : ''); ?>>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <button class="btn btn-primary btn-sm" type="submit">Save</button>
                        <a class="btn btn-danger btn-sm" href="<?php echo e(url('roles')); ?>">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>
    <script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatables.script.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Check all permissions
            $('#check-all').on('click', function() {
                var isChecked = $(this).data('checked');
                if (isChecked) {
                    // Uncheck all checkboxes
                    $('input[name="permissions[]"]').prop('checked', false);
                    $(this).data('checked', false);
                } else {
                    // Check all checkboxes
                    $('input[name="permissions[]"]').prop('checked', true);
                    $(this).data('checked', true);
                }
            });

            // Check Main Module functionality
            $('.check-module').on('change', function() {
                var parentId = $(this).val();
                var isChecked = $(this).is(':checked');
                $('tr.sub-module[data-parent="' + parentId + '"] input.check-submodule').prop('checked',
                    isChecked);
                $('tr.sub-permissions[data-parent="' + parentId + '"] input[name="permissions[]"]').prop(
                    'checked', isChecked);
            });

            // Check Sub Module functionality
            $('.check-submodule').on('change', function() {
                var parentId = $(this).val();
                var isChecked = $(this).is(':checked');
                $('tr.sub-permissions[data-parent="' + parentId + '"] input[name="permissions[]"]').prop(
                    'checked', isChecked);
                var $moduleCheckbox = $('.check-module[value="' + parentId + '"]');
                if (isChecked) {
                    $moduleCheckbox.prop('checked', true);
                } else {
                    var allUnchecked = $('tr.sub-permissions[data-parent="' + parentId +
                            '"] input[name="permissions[]"]').length ===
                        $('tr.sub-permissions[data-parent="' + parentId +
                            '"] input[name="permissions[]"]:checked').length;
                    if (!allUnchecked) {
                        $moduleCheckbox.prop('checked', false);
                    }
                }
            });

            // Update sub-module checkboxes when permissions are changed
            $('#permissionsTable').on('change', 'input[name="permissions[]"]', function() {
                var isChecked = $(this).is(':checked');
                var $row = $(this).closest('tr');
                var parentId = $row.data('parent');
                var $subModuleCheckbox = $('.check-submodule[value="' + parentId + '"]');
                var $moduleCheckbox = $('.check-module[value="' + parentId + '"]');

                if (isChecked) {
                    $subModuleCheckbox.prop('checked', true);
                    $moduleCheckbox.prop('checked', true);
                } else {
                    var allUnchecked = $('tr.sub-permissions[data-parent="' + parentId +
                            '"] input[name="permissions[]"]').length ===
                        $('tr.sub-permissions[data-parent="' + parentId +
                            '"] input[name="permissions[]"]:checked').length;
                    if (!allUnchecked) {
                        $subModuleCheckbox.prop('checked', false);
                        var allUncheckedModule = $('tr.sub-module input.check-submodule').length ===
                            $('tr.sub-module input.check-submodule:checked').length;
                        if (!allUncheckedModule) {
                            $moduleCheckbox.prop('checked', false);
                        }
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/Permission/index.blade.php ENDPATH**/ ?>