<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerAccount extends Model
{
    protected $table = 'customers_account';
    protected $primaryKey = 'id_customers_account';
    protected $fillable = [
        'customers_id',
        'account_name',
        'account_no',
        'debit',
        'credit',
        'balance',
        'status',
    ];
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }
}
