<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SupplierPaymentHistory extends Model
{
    protected $table = 'suppliers_payment_history';
    protected $primaryKey = 'id_suppliers_payment_history';

    protected $fillable = [
        'suppliers_id',
        'invoice_no',
        'invoice_date',
        'amount',
        'status',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'suppliers_id');
    }
}
