@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Main Account</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <h2 class="az-content-title" style="display: inline">Main Account List</h2>
        <span>
            @can('Chart of Account list')

                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i>
                    Add Account
                </button>
            @endcan
        </span>
    </div>
    <div class="card card-body pd-20">
        <div class="row dataTables_wrapper">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div>
                    <table id="example2" class="table">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($main_account as $key => $m_acc)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $m_acc->main_account_number }}</td>
                                    <td>{{ $m_acc->main_account_name }}</td>
                                    <td>{{ $m_acc->a_urdu_name }}</td>
                                    <td>{{ $m_acc->created_at }}</td>
                                    <td>
                                        @can('Control Account list')
                                            <a class="btn rounded shadow-base text-info"
                                                href="{{ url('control_account/' . $m_acc->id_main_account) }}">
                                                <i class="fa-solid fa-arrow-up-right-from-square"></i>
                                                <strong>Control account</strong>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Main Account Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Main Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('main_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <label for="accountName">Account Name <span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label class=" " style="float: inline-end;" > <span style="color:red;">*</span> کھا تہ</label>
                            <input type="text" name="a_urdu_name" class="form-control" id="a_urdu_name_add"
                                dir="rtl" />
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        // Restrict input to Urdu characters only
        document.getElementById('a_urdu_name_add').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;
            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        $(function() {
            $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Main Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Main Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Main Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Main Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });
    </script>
@endpush
