@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Products</span>
        <span>Edit Product</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Product
        <span>
            <a href="{{ route('products.list', ['id' => Crypt::encrypt($product->brands_id)]) }}" class="btn border"
                style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Products
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Product Details</h5>
                @if (Session('alert'))
                    <div class="alert alert-card alert-<?php echo Session('alert-class'); ?>" role="alert">
                        <?php echo Session('alert'); ?>
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    </div>
                @endif
                <form action="{{ route('products.update', Crypt::encrypt($product->id_products)) }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    @method('POST')

                    <input type="hidden" name="brands_id" value="{{ $product->brands_id }}">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Brand</label>
                                <input disabled name="products_brand" id="products_brand"
                                    value="{{ $product->brand->brands_name }}" class="form-control" />
                                @error('products_brand')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name</label>
                                <input name="products_name" id="products_name" class="form-control"
                                    value="{{ old('products_name', $product->products_name) }}" />
                                @error('products_name')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Sale Price</label>
                                <input name="products_sale_price" id="products_sale_price" class="form-control"
                                    value="{{ old('products_sale_price', $product->products_sale_price) }}" />
                                @error('products_sale_price')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Purchase Price</label>
                                <input name="products_purchase_price" id="products_purchase_price" class="form-control"
                                    value="{{ old('products_purchase_price', $product->products_purchase_price) }}" />
                                @error('products_purchase_price')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Retail Price</label>
                                <input name="products_retail_price" id="products_retail_price" class="form-control"
                                    value="{{ old('products_retail_price', $product->products_retail_price) }}" />
                                @error('products_retail_price')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="products_status">Status</label>
                                    <select id="products_status" name="products_status" class="form-control">
                                        <option value="">Select</option>
                                        <option value="1"
                                            {{ old('products_status', $product->products_status) == '1' ? 'selected' : '' }}>
                                            Active</option>
                                        <option value="0"
                                            {{ old('products_status', $product->products_status) == '0' ? 'selected' : '' }}>
                                            In-Active</option>
                                    </select>
                                    @error('products_status')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                    for="category_id">Category</label>
                                <select name="category_id" id="category_id" class="form-control">
                                    <option value="">Select Category</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id_products_category }}"
                                            {{ $category->id_products_category == old('category_id', $product->category_id) ? 'selected' : '' }}>
                                            {{ $category->products_category_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                    for="measurement_unit_id">Measurement Unit</label>
                                <select name="measurement_unit_id" id="measurement_unit_id" class="form-control">
                                    <option value="">Select Measurement Unit</option>
                                    @foreach ($units as $unit)
                                        <option value="{{ $unit->id_measurement_unit }}"
                                            {{ $unit->id_measurement_unit == old('measurement_unit_id', $product->measurement_unit_id) ? 'selected' : '' }}>
                                            {{ $unit->measurement_unit_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="products_qt_per_unit">Qty
                                    Per Unit</label>
                                <input name="products_qt_per_unit" id="products_qt_per_unit" class="form-control"
                                    value="{{ old('products_qt_per_unit', $product->products_qt_per_unit) }}" />
                                @error('products_qt_per_unit')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                    for="products_threshold">Threshold</label>
                                <input name="products_threshold" id="products_threshold" class="form-control"
                                    value="{{ old('products_threshold', $product->products_threshold) }}" />
                                @error('products_threshold')
                                    <span class="form-text text-muted">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600" for="products_desc">Products
                            Desc</label>
                        <textarea class="form-control" name="products_desc" id="products_desc">{{ old('products_desc', $product->products_desc) }}</textarea>
                        @error('products_desc')
                            <span class="form-text text-muted">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Images</label>
                        <input type="file" name="products_images[]" id="products_images" class="form-control"
                            multiple />
                        @error('products_images')
                            <span class="form-text text-muted">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Update
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection
