@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Products Categories</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="az-content-title" style="display: inline">Product Sub Category</h2>
            <nav aria-label="breadcrumb" class="mt-3">
                <ol class="breadcrumb bg-transparent p-2  border rounded">
                    <li class="breadcrumb-item">
                        <a href="{{ url('product') }}" class="text-decoration-none text-dark">
                            <i class="fas fa-home me-1"></i> Product Category List
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-primary" aria-current="page">
                        <i class="fas fa-folder-open me-1"></i> {{ $product->products_category_name }}
                    </li>
                </ol>
            </nav>
        </div>

        <span>
            @can('Product Categories add')
                <a href="javascript:window.history.back()" class="btn btn-outline-secondary me-2">
                    <i class="fas fa-arrow-left me-1"></i> Back to Main Account
                </a>
                <a href="#" class="btn btn-az-primary" style="float: right" data-toggle="modal"
                    data-target="#createModal">
                    <i class="fa-solid fa-plus"></i> Add Product Category
                </a>
            @endcan
        </span>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Product Sub Category Name</th>
                                <th class="wd-10p">Product Sub Category (Urdu)</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($products_sub_cat as $key => $prod)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $prod->name }}</td>
                                    <td>{{ $prod->name_urdu }}</td>
                                    <td>
                                        @if ($prod->status == 1)
                                            <span class="btn btn-rounded btn-success text-white">Active</span>
                                        @else
                                            <span class="btn btn-rounded btn-danger">In Active</span>
                                        @endif
                                    </td>
                                    @php
                                        $user = \App\User::find($prod->created_by);
                                    @endphp
                                    <td>{{ $user ? $user->name : $prod->created_by }}</td>
                                    <td>{{ date('d-m-Y', strtotime($prod->created_at)) }}</td>
                                    <td>
                                        <a class="btn rounded shadow-base text-info"
                                            href="{{ url('product_sub_sub_cat/' . $product->id_products_category . '/' . $prod->id_pro_sub_cat) }}">
                                            <i class="fa-solid fa-arrow-up-right-from-square"></i> <strong>Sub
                                                Category</strong>
                                        </a>
                                        @can('Product Categories edit')
                                            <a class="btn rounded shadow-base" title="Edit Product" href="#"
                                                data-toggle="modal" data-target="#editModal"
                                                data-id="{{ $prod->id_pro_sub_cat }}" data-name="{{ $prod->name }}"
                                                data-name_urdu="{{ $prod->name_urdu }}" data-status="{{ $prod->status }}"
                                                data-id_products_category="{{ $product->id_products_category }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('Product Categories delete')
                                            <a class="btn rounded shadow-base" title="Delete Product" href="#"
                                                data-toggle="modal" data-target="#deleteModal"
                                                data-id="{{ $prod->id_pro_sub_cat }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <span class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Product Sub Category Name</th>
                                <th class="wd-10p">Product Sub Category (Urdu)</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    {{-- {{dd($product)}} --}}
    <!-- Create Modal -->
    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createModalLabel">Add New Product Sub Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="createForm" action="{{ url('sub_cat/store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <select class="form-control" name="id_products_category" id="" hidden>
                            <option value="{{ $product->id_products_category }}">
                                {{ $product->products_category_name }}</option>
                        </select>
                        <div class="form-group">
                            <label for="name">Product Sub Category Name</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="name_urdu">Product Sub Category Name (Urdu)</label>
                            <input type="text" class="form-control" name="name_urdu">
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status" required>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Product Sub Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="editForm" action="" method="POST">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="id" id="edit-id">
                        <select class="form-control" name="id_products_category" hidden id="edit-id_products_category">
                            <option value="{{ $product->id_products_category ?? '' }}">
                                {{ $product->products_category_name ?? 'Select Category' }}
                            </option>
                        </select>

                        <div class="form-group">
                            <label for="edit-name">Product Sub Category Name</label>
                            <input type="text" class="form-control" id="edit-name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="edit-name-urdu">Product Sub Category Name (Urdu)</label>
                            <input type="text" class="form-control" id="edit-name-urdu" name="name_urdu">
                        </div>
                        <div class="form-group">
                            <label for="edit-status">Status</label>
                            <select class="form-control" id="edit-status" name="status" required>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Product Sub Category?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        titleAttr: 'Export to CSV',
                        className: 'btn btn-success btn-sm'
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        titleAttr: 'Export to Excel',
                        className: 'btn btn-primary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        titleAttr: 'Export to PDF',
                        className: 'btn btn-danger btn-sm'
                    }
                ]
            });

            // $('#editModal').on('show.bs.modal', function(event) {
            //     var button = $(event.relatedTarget); // Button that triggered the modal
            //     var id = button.data('id');
            //     var name = button.data('name');
            //     var name_urdu = button.data('name_urdu');
            //     var status = button.data('status');

            //     var modal = $(this);
            //     modal.find('#edit-id').val(id);
            //     modal.find('#edit-name').val(name);
            //     modal.find('#edit-name-urdu').val(name_urdu);
            //     modal.find('#edit-status').val(status);

            //     var actionUrl = '/sub_cat/update/' + id;
            //     modal.find('#editForm').attr('action', actionUrl);
            // });
            $('#editModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var id = button.data('id');
                var id_products_category = button.data(
                    'id_products_category'); // Ensure this is correctly set
                var name = button.data('name');
                var name_urdu = button.data('name_urdu');
                var status = button.data('status');

                var modal = $(this);
                modal.find('#edit-id').val(id);
                modal.find('#edit-id_products_category').val(
                    id_products_category); // Ensure this line is correct
                modal.find('#edit-name').val(name);
                modal.find('#edit-name-urdu').val(name_urdu);
                modal.find('#edit-status').val(status);

                // Use the pattern that's working for you
                modal.find('#editForm').attr('action', "{{ url('sub_cat/update') }}/" + id);
            });


            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var id = button.data('id');

                var modal = $(this);
                // var actionUrl = '/sub_cat/destroy/' + id;
                // modal.find('#deleteForm').attr('action', actionUrl);
                modal.find('#deleteForm').attr('action', "{{ url('sub_cat/destroy') }}/" + id);
            });
        });
    </script>
@endpush
