<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class GoodReceiptDetail extends Model
{
    protected $primaryKey = 'id_grd';
    protected $table = 'good_receipts_details';
    protected $fillable = [
        'good_receipts_id',
        'truck_id',
        'goods_name',
        'marka',
        'bori',
        'weight',
        'rate',
        'remarks',
    ];

    public function goodReceipt()
    {
        return $this->belongsTo(GoodReceipts::class, 'good_receipts_id');
    }

    public function goodReceiptTruck()
    {
        return $this->belongsTo(GoodReceiptTruck::class, 'truck_id');
    }
}
