<?php
namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrderDetails extends Model
{
    use HasFactory;

    // Define the table associated with the model
    protected $table = 'purchase_order_details';

    // Define the primary key
    protected $primaryKey = 'id_purchase_order_details';

    // Define the fillable attributes
    protected $fillable = [
        'purchase_order_id',
        'items_name',
        'marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'status',
    ];

    /**
     * Relationship: Purchase Order Details belong to a Purchase Order
     */
    public function purchaseOrder()
    {
        return $this->belongsTo(PurchaseOrder::class, 'purchase_order_id', 'id_purchase_order');
    }
}
