<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalesItemDetail extends Model
{
    protected $primaryKey = 'id_sid';
    protected $table = 'sales_items_details';
    protected $fillable = [
        'sales_id',
        'items_name',
        'marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'notes',
        'status',
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sales_id');
    }

    // public function salesPerBoriWeight()
    // {
    //     return $this->hasMany(SalesPerBoriWeight::class, 'sales_items_details_id');
    // }
}
