@extends('layouts.master')

<style>
    .d-none {
        display: none;
    }

    .custom-dropdown {
        position: relative;
        display: inline-block;
        width: 100%;
    }

    .dropdown-toggle {
        background: white;
        border: 1px solid #ced4da;
        border-radius: 4px;
        padding: 5px;
        cursor: pointer;
    }

    .dropdown-content {
        display: none;
        position: absolute;
        background-color: white;
        width: 100%;
        max-height: 300px;
        overflow-y: auto;
        border: 1px solid #ced4da;
        border-radius: 4px;
        box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
        z-index: 1;
    }

    .table-hover tbody tr:hover {
        background-color: #f5f5f5;
    }


    .truck-details {
        cursor: pointer;
    }

    .az-content-label-urdu {
        float: right;
        font-size: 2.4vh;
        font-family: 'Jameel Noori Nastaleeq', serif;
        margin-bottom: 10px
    }

    .az-content-label {
        margin-top: 10px
    }
</style>

@section('content')
    <!-- Breadcrumb and Page Title -->
    <div class="az-content-breadcrumb">
        <span>Sale Rate</span>
        <span> Create Sale Rate Rate</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
         Create Sale Rate Rate
        <span>
            <a href="{{ route('sale_rate.list') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to List
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20"> Create Sale Rate </h5>
                <form action="{{ route('sale_rate.store') }}" method="POST">
                    @csrf

                    <!-- Error Display -->
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label" for="sales_date">Date</label>
                                <input type="text" class="form-control" name="sales_date" id="sales_date" required
                                    autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label-urdu" for="truck">{{-- Truck / --}} ٹرک</label>

                                <!-- Hidden native select element -->
                                {{-- <select class="form-control d-none" name="good_receipts_truck_id" id="truck" required>
                                    <option value="">- Select -</option>
                                    @foreach ($trucks as $truck)
                                        <option value="{{ $truck->id_truck }}">
                                            {{ $truck->truck_no }}
                                        </option>
                                    @endforeach
                                </select> --}}



                                <!-- Visible custom dropdown -->
                                <div class="custom-dropdown">
                                    <div class="dropdown-toggle form-control" id="truck-toggle">- Select -</div>
                                    <div class="dropdown-content">
                                        <input type="text" id="truck-search" class="form-control"
                                            placeholder="Search the truck number..."
                                            onkeyup="showOnlyThisTruckDetails(this.value)">
                                      <table class="table table-bordered table-hover">
                                            <thead>
                                                <tr>
                                                    {{-- <th>Truck No</th>
                                                    <th>Item</th>
                                                    <th>Marka</th>
                                                    <th>Quantity</th>
                                                    <th>Weight</th>
                                                    <th>Price</th> --}}

                                                    <th>S.No</th>
                                                    <th>Date</th>
                                                    <th>Client</th>
                                                    <th>Vehicle No</th>
                                                    <th>Products</th>
                                                    <th>Marks</th>
                                                    <th>Qty</th>
                                                    <th>Weight</th>
                                                    <th>Price</th>
                                                    <th>BasicAccount</th>
                                                    <th>Remarks</th>
                                                    <th>Created By</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            {{-- <tbody id="truck-table-body">
                                                @foreach ($trucks as $truck)
                                                    @foreach ($truck->goodReceipts as $receipt)
                                                        @foreach ($receipt->goodReceiptDetails as $detail)
                                                            <tr class="truck-details"
                                                                data-truck-id="{{ $truck->id_truck }}">
                                                                <td>{{ $truck->truck_no }}</td>
                                                                <td>{{ $detail->goods_name }}</td>
                                                                <td>{{ $detail->marka }}</td>
                                                                <td>{{ $detail->bori }}</td>
                                                                <td>{{ $detail->weight }}</td>
                                                                <td>{{ $detail->rate }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @endforeach
                                                @endforeach
                                            </tbody> --}}
                                        </table>
                                    </div>
                                </div>

                            </div>

                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label" for="products">{{-- Customers / --}} Products</label>
                                <select class="form-control select2" name="products" id="products" required>
                                    <option value="">- Select -</option>
                                    {{-- @foreach ($customers as $customer)
                                        <option value="{{ $customer->id_customers }}">
                                            {{ $customer->customer_name }} - {{ $customer->customer_name_urdu }}
                                        </option>
                                    @endforeach --}}
                                </select>
                            </div>
                            @error('customer_id')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror

                            <button type="button" class="btn btn-az-primary btn-block mt-2" onclick="addBoriRow()">
                                <span class="mdi mdi-arrow-expand-up" ></span> Add More
                            </button>
                        </div>

                        <!-- Item Details Section -->
                        <div class="col-md-12 mt-5">
                            <h4>Item Details{{-- / آئٹم کی تفصیلات --}}</h4>
                            <div class="shadow p-3 bg-light rounded">
                                <table class="table" id="item-table">
                                    <thead>
                                        <tr>
                                            {{-- <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                مارکہ</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                آئٹم</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                بوری</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                وزن</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                ریٹ</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                رقم</th>
                                            <th
                                                style="font-size: 2vh; color: black; font-family: 'Jameel Noori Nastaleeq', serif; ">
                                                Action</th> --}}


                                                 <th>S.No</th>
                                                    <th>Date</th>
                                                    <th>Client</th>
                                                    <th>Vehicle No</th>
                                                    <th>Products</th>
                                                    <th>Marks</th>
                                                    <th>Qty</th>
                                                    <th>Weight</th>
                                                    <th>Price</th>
                                                    <th>BasicAccount</th>
                                                    <th>Remarks</th>
                                                    <th>Created By</th>
                                                    <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <select class="form-control marka-select" name="marka[]">
                                                    <option value="">- Select -</option>
                                                </select>
                                            </td>
                                            <td>
                                                <select class="form-control item-select" name="items_name[]">
                                                    <option value="">- Select -</option>
                                                </select>
                                            </td>
                                            <td><input type="text" class="form-control" name="bori[]"></td>
                                            <td><input type="text" class="form-control" name="weight[]"></td>
                                            <td><input type="text" class="form-control" name="rate[]"></td>
                                            <td><input type="text" class="form-control" name="amount[]"></td>
                                            <td>
                                                <button type="button" class="btn rounded shadow-base"
                                                    onclick="removeRow(this)">
                                                    <i class="text-danger fa-solid fa-trash-can"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-az-primary btn-block mt-2" onclick="addRow()">
                                    <span class="mdi mdi-arrow-expand-up"></span> Add More
                                </button>
                            </div>
                        </div>

                        <!-- Additional Bori Details Section -->
                        <div class="col-md-12 mt-4">
                            <h4>Additional Bori Details{{-- / اضافی بوری کی تفصیلات --}}</h4>
                            <div class="shadow p-3 bg-light rounded">
                                <table class="table" id="bori-table">
                                    <thead>
                                        <tr>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                بوری نمبر</th>
                                            <th
                                                style="font-size: 2vh; color: black; text-align: right;  font-family: 'Jameel Noori Nastaleeq', serif;">
                                                وزن</th>
                                            <th
                                                style="font-size: 2vh; color: black;  font-family: 'Jameel Noori Nastaleeq', serif; ">
                                                Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><input type="text" class="form-control" name="bori_number[]"></td>
                                            <td><input type="text" class="form-control" name="per_bori_weight[]"></td>
                                            <td>
                                                <button type="button" class="btn rounded shadow-base"
                                                    onclick="removeBoriRow(this)">
                                                    <i class="text-danger fa-solid fa-trash-can"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-az-primary btn-block mt-2" onclick="addBoriRow()">
                                    <span class="mdi mdi-arrow-expand-up"></span> Add More
                                </button>
                            </div>
                        </div>

                        <!-- Totals Section -->
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <h4>Totals</h4>
                                <div class="form-group row">
                                    <label for="total_bori" class="col-sm-2 col-form-label">Total Bori:</label>
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="total_bori" name="total_bori"
                                            readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="remaining_amount" class="col-sm-2 col-form-label">Remaining
                                        Amount:</label>
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="remaining_amount"
                                            name="remaining_amount" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="cash_received" class="col-sm-2 col-form-label">Cash Received:</label>
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="cash_received"
                                            name="cash_received">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="total_amount" class="col-sm-2 col-form-label">Total Amount:</label>
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="total_amount" name="total_amount"
                                            readonly>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-5">
                            <a href="{{ route('sale_rate.list') }}" class="btn btn-danger pd-x-20">Cancel</a>
                            <button type="submit" class="btn btn-az-primary pd-x-20">Submit</button>
                        </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        function addRow() {
            var row = `<tr>
                <td>
                    <select class="form-control marka-select" name="marka[]">
                        <option value="">- Select -</option>
                    </select>
                </td>
                <td>
                    <select class="form-control item-select" name="items_name[]">
                        <option value="">- Select -</option>
                    </select>
                </td>
                <td><input type="text" class="form-control" name="bori[]"></td>
                <td><input type="text" class="form-control" name="weight[]"></td>
                <td><input type="text" class="form-control" name="rate[]"></td>
                <td><input type="text" class="form-control" name="amount[]"></td>
                <td>
                    <button type="button" class="btn rounded shadow-base" onclick="removeRow(this)">
                        <i class="text-danger fa-solid fa-trash-can"></i>
                    </button>
                </td>
            </tr>`;
            $('#item-table tbody').append(row);

            // Populate marka and item selects in the new row
            populateMarkaAndItems($('#item-table tbody tr:last'));
        }

        function removeRow(button) {
            $(button).closest('tr').remove();
            updateTotals();
        }

        function addBoriRow() {
            var row = `
            <tr>
                <td><input type="text" class="form-control" name="bori_number[]"></td>
                <td><input type="text" class="form-control" name="per_bori_weight[]"></td>
                <td>
                    <button type="button" class="btn rounded shadow-base" onclick="removeBoriRow(this)">
                        <i class="text-danger fa-solid fa-trash-can"></i>
                    </button>
                </td>
            </tr>`;
            $('#bori-table tbody').append(row);
            updateBoriDetails();
        }

        function removeBoriRow(button) {
            $(button).closest('tr').remove();
            updateBoriDetails();
        }

        function updateBoriDetails() {
            var totalBori = $('#bori-table tbody tr').length;
            var totalWeight = 0;

            $('#bori-table tbody tr').each(function() {
                var weight = parseFloat($(this).find('input[name="per_bori_weight[]"]').val()) || 0;
                totalWeight += weight;
            });

            // Update the Item Details section
            $('#item-table tbody tr').find('input[name="bori[]"]').val(totalBori);
            $('#item-table tbody tr').find('input[name="weight[]"]').val(totalWeight);

            // Update Totals section
            $('#total_bori').val(totalBori);
            $('#total_weight').val(totalWeight);
        }

        // Bind the input change event to update Bori Details automatically
        $('#bori-table').on('input', 'input[name="bori_number[]"], input[name="per_bori_weight[]"]', function() {
            updateBoriDetails();
        });

        // Initialize the page with any existing data
        // $(document).ready(function() {
        //     updateBoriDetails();
        // });

        function populateMarkaAndItems(newRow) {
            var truckId = $('#truck').val();
            if (truckId) {
                $.ajax({
                    url: '{{ route('get.truck.items', '__TRUCK_ID__') }}'.replace('__TRUCK_ID__', truckId),
                    type: 'GET',
                    success: function(data) {
                        // Populate marka select in the new row
                        newRow.find('.marka-select').empty().append('<option value="">- Select -</option>');
                        $.each(data.markas, function(_, marka) {
                            newRow.find('.marka-select').append(
                                `<option value="${marka}">${marka}</option>`);
                        });

                        // Populate item select in the new row
                        newRow.find('.item-select').empty().append('<option value="">- Select -</option>');
                    }
                });
            }
        }

        // Fetch items and markas when the truck is selected
        $('#truck').on('change', function() {
            var truckId = $(this).val();
            if (truckId) {
                $('#item-table tbody tr').each(function() {
                    populateMarkaAndItems($(this));
                });
            }
        });

        // Fetch items based on selected marka
        $('#item-table').on('change', 'select[name="marka[]"]', function() {
            var marka = $(this).val();
            var truckId = $('#truck').val();
            if (marka && truckId) {
                $.ajax({
                    url: '{{ route('get.items.by.marka', ['truckId' => '__TRUCK_ID__', 'marka' => '__MARKA__']) }}'
                        .replace('__TRUCK_ID__', truckId).replace('__MARKA__', marka),
                    type: 'GET',
                    success: function(data) {
                        var itemSelect = $(this).closest('tr').find('.item-select');
                        itemSelect.empty().append('<option value="">- Select -</option>');
                        $.each(data, function(id, name) {
                            itemSelect.append(`<option value="${name}">${name}</option>`);
                        });
                    }.bind(this)
                });
            }
        });

        function updateTotals() {
            let totalBori = 0;
            let totalAmount = 0;

            // Loop through each row to calculate totals
            $('#item-table tbody tr').each(function() {
                let bori = parseFloat($(this).find('input[name="bori[]"]').val()) || 0;
                let amount = parseFloat($(this).find('input[name="amount[]"]').val()) || 0;

                totalBori += bori;
                totalAmount += amount;
            });

            // Update Total Bori and Total Amount fields
            $('#total_bori').val(totalBori);
            $('#total_amount').val(totalAmount);

            // Update Remaining Amount based on Cash Received
            let cashReceived = parseFloat($('#cash_received').val()) || 0;
            $('#remaining_amount').val(totalAmount - cashReceived);
        }

        function handleInputChange() {
            // Recalculate totals when any input changes
            $('#item-table').on('input', 'input[name="bori[]"], input[name="amount[]"]', updateTotals);

            // Update remaining amount when cash received changes
            $('#cash_received').on('input', function() {
                let cashReceived = parseFloat($(this).val()) || 0;
                let totalAmount = parseFloat($('#total_amount').val()) || 0;
                $('#remaining_amount').val(totalAmount - cashReceived);
            });
        }

        // Initialize the input change handler
        $(document).ready(function() {
            $("#sales_date").datepicker({
                dateFormat: "yy-mm-dd"
            });

            $('#customers').select2({
                theme: 'default'
            });

            handleInputChange();
            // Update totals when rows are added or removed
            $('#item-table').on('DOMSubtreeModified', updateTotals);

            // for truck custom dropdown

            // Toggle custom dropdown content
            $('#truck-toggle').click(function() {
                $('.dropdown-content').toggle();
            });

            // Handle truck selection
            $('.truck-details').click(function() {
                var truckId = $(this).data('truck-id');
                var truckNumber = $(this).find('td:first').text();

                // Update the hidden select element
                $('#truck').val(truckId);

                if (truckId) {
                    $('#item-table tbody tr').each(function() {
                        populateMarkaAndItems($(this));
                    });
                }

                // Update the custom dropdown display
                $('#truck-toggle').text(truckNumber);

                // Hide the dropdown content
                $('.dropdown-content').hide();
            });

            // Hide the custom dropdown if clicked outside
            $(document).click(function(event) {
                if (!$(event.target).closest('.custom-dropdown').length) {
                    $('.dropdown-content').hide();
                }
            });
        });

        // Filter the truck table based on search input
        function showOnlyThisTruckDetails(searchKeys) {
            // Convert searchKeys to lowercase for case-insensitive search
            var filter = searchKeys.toLowerCase();

            // Loop through all rows in the table and hide those that don't match the search query
            $('#truck-table-body tr').each(function() {
                var truckNo = $(this).find('td:first').text().toLowerCase();

                if (truckNo.includes(filter)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        }
    </script>
@endpush
