@extends('layouts.master')
@section('content')

    <div class="az-content-breadcrumb">
        <span>Supplier</span>
        <span>Add Supplier </span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Supplier
        <span>
            <a href="{{ route('supplier.list') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Supplier
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Supplier</h5>
                <form method="post" action="{{ route('supplier.store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Supplier Name (English) <span style="color:red;">*</span></label>
                                <input type="text" name="supplier_name" class="form-control" required />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="" style="float: inline-end;"> کھا تہ </label>
                                <input type="text" name="supplier_name_urdu" class="form-control" id="supplier_name_urdu"
                                    dir="rtl" />
                            </div>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Email</label>
                                <input type="email" name="email" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Contact Person</label>
                                <input type="text" name="contact_person" class="form-control" />
                            </div>
                        </div>

                    </div>
                    <div class="row row-sm mg-b-20">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Address (English) </label>
                                <input type="text" name="address" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class=""> Address (Urdu) </label>
                                <input type="text" name="supplier_address_urdu" class="form-control"
                                    id="supplier_address_urdu" dir="rtl" />
                            </div>
                        </div>

                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 1</label>
                                <input type="text" name="phone_1" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 2</label>
                                <input type="text" name="phone_2" class="form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Website</label>
                                <input type="text" name="website" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option value="0">Active</option>
                                    <option value="1">In Active</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Opening Balance Dr</label>
                                <input type="text" name="blance_dr" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Opening Balance Cr</label>
                                <input type="text" name="blance_cr" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Opening Balance Date</label>
                                {{-- <input type="date" name="opening_date" class="form-control" /> --}}
                                <input type="text" id="opening_date" name="opening_date" class="form-control"
                                    placeholder="dd/mm/yyyy" required />
                            </div>
                        </div>
                    </div>

                    <a type="button" href="{{ route('supplier.list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $("#opening_date").datepicker({
                dateFormat: "yy-mm-dd" // You can customize the date format here
            });
        });

        document.getElementById('supplier_name_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        document.getElementById('supplier_address_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
    </script>
@endpush
