@extends('layouts.master')

@section('content')

    <style>
        .iti.iti--allow-dropdown.iti--show-flags {
            width: 100%;
        }
    </style>
    <div class="az-content-breadcrumb">
        <span>Customer list</span>
        <span>Add Customer</span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">
        Add Customer
        <span>
            <a href="{{ url('customers') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i>
                Back to Customer
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Customer Details</h5>
                <form method="post" id="myForm" enctype="multipart/form-data" action="{{ url('customers/store') }}">
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">
                                    {{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-2 offset-10">
                            <button type="submit" class="btn btn-az-primary btn-block mb-4"
                                style="float: right">Submit</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-4">
                            <div class="form-group">
                                <label>Opening Date</label>
                                <input type="text" id="customer_ope_date" name="customer_ope_date" class="form-control"
                                    placeholder="dd/mm/yyyy" value="{{ old('customer_ope_date') }}" readonly />
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Customer Name (English) <span style="color:red;">*</span></label>
                                <input type="text" name="customer_name" class="form-control"
                                    value="{{ old('customer_name') }}" required />
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label class="" style="float: inline-end;"> کھا تہ </label>
                                <input type="text" name="customer_name_urdu" class="form-control" id="customer_name_urdu"
                                    value="{{ old('customer_name_urdu') }}" />
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group">
                                <label>Customer Email</label>
                                <input type="text" name="customer_email" class="form-control"
                                    value="{{ old('customer_email') }}" />
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Contact Number</label>
                                <input type="text" id="whatsapp_number" class="form-control" name="customer_phone"
                                    value="{{ old('customer_phone') }}">
                                <div class="invalid-feedback1"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Contact - Other / PTCL / WHATSAPP</label>
                                <input type="text" class="form-control" name="customer_whatsapp"
                                    value="{{ old('customer_whatsapp') }}">
                                <div class="invalid-feedback2"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group">
                                <label>Customer Address (English)</label>
                                <input type="text" name="customer_address" class="form-control"
                                    value="{{ old('customer_address') }}" />
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label class="" style="float: inline-end;"> گاہک کا پتہ </label>
                                <input type="text" name="customer_address_urdu" id="customer_address_urdu"
                                    class="form-control" value="{{ old('customer_address_urdu') }}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">City</label>
                                <select class="form-control" name="city" id="city">
                                    @foreach ($cities as $key => $city)
                                        <option value="{{ $city->id_city }}">
                                            {{ $city->city_name }} | {{ $city->city_name_urdu }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label>Customer Reference</label>
                                <input type="text" class="form-control" name="customer_reference"
                                    value="{{ old('customer_reference') }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label>Remarks (English)</label>
                                <input type="text" class="form-control" name="customer_remarks"
                                    value="{{ old('customer_remarks') }}">
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="" style="float: inline-end;">ریمارکس</label>
                                <input type="text" class="form-control" id="customer_remarks_urdu"
                                    name="customer_remarks_urdu" value="{{ old('customer_remarks_urdu') }}">
                            </div>
                        </div>
                    </div>

                    <div class="row my-3">
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label>Customer Image</label>
                                <input type="file" class="form-control" name="customer_image" />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label>Status</label>
                                <select class="form-control" name="customer_status" id="customer_status">
                                    <option value="0" {{ old('customer_status') == '0' ? 'selected' : 'selected' }}>
                                        Active
                                    </option>
                                    <option value="1" {{ old('customer_status') == '1' ? 'selected' : '' }}>In Active
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="customer_records d-none"></div>
                    <div class="customer_records_dynamic"></div>
                    @csrf

                    <h5 class="card-title mg-b-20">Add Account Details</h5>
                    <hr>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Opening Balance Debit</label>
                                <input type="text" oninput="formatWithCommas(this)" name="customer_ope_bal_dr"
                                    class="form-control" value="{{ old('customer_ope_bal_dr') }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Opening Balance Credit</label>
                                <input oninput="formatWithCommas(this)" type="text" name="customer_ope_bal_cr"
                                    class="form-control" value="{{ old('customer_ope_bal_cr') }}" />
                            </div>
                        </div>
                    </div>

                    <a href="{{ url('customers') }}" class="btn btn-danger btn-block mt-2">Back</a>

                </form>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        //  $(document).ready(function() {
        //     $("#customer_ope_date").datepicker({
        //         dateFormat: "yy-mm-dd" // You can customize the date format here
        //     });
        // });
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                // Submit the form
                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });


        $(document).ready(function() {
            // Set the default date to today
            var today = new Date();
            var formattedDate = today.getFullYear() + '-' + ('0' + (today.getMonth() + 1)).slice(-2) + '-' + ('0' +
                today.getDate()).slice(-2);

            $("#customer_ope_date").val(formattedDate);

            // Initialize datepicker with custom format
            $("#customer_ope_date").datepicker({
                dateFormat: "yy-mm-dd" // Customize the date format here
            });
        });


        // document.getElementById('customer_name_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;

        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        // document.getElementById('customer_address_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;

        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        // document.getElementById('customer_remarks_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;

        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        $('.extra-fields-customer').click(function() {
            $('.customer_records').clone().appendTo('.customer_records_dynamic');
            $('.customer_records_dynamic .customer_records').addClass('single remove');
            $('.single .extra-fields-customer').remove();
            $('.single').append(
                '<a href="#" class="remove-field btn-remove-customer btn btn-danger">Remove Fields</a>');
            $('.customer_records_dynamic > .single').attr("class", "remove");

            $('.customer_records_dynamic input').each(function() {
                var count = 0;
                var fieldname = $(this).attr("name");
                $(this).attr('name', fieldname + count);
                count++;
            });

        });

        $(document).on('click', '.remove-field', function(e) {
            $(this).parent('.remove').remove();
            e.preventDefault();
        });
        // Ajax to get City
        $(document).ready(function() {

            $('#country-dropdown').on('change', function() {
                var country_id = this.value;
                // alert(country_id)
                $("#city-dropdown").html('');
                $.ajax({
                    url: "{{ url('get-cities-by-country') }}",
                    type: "POST",
                    data: {
                        country_id: country_id,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#city-dropdown').html(
                            '<option value="">Select City</option>');
                        $.each(result.cities, function(key, value) {
                            $("#city-dropdown").append('<option value="' +
                                value.id +
                                '">' + value.name + '</option>');
                        });
                    }
                });
            });
            $('#city').select2({
                theme: 'default'
            });
        });
    </script>

    <script>
        // Get Already Customer
        $("#phone0").on("keyup change", function(e) {
            let val = $(this).val();

            $.ajax({
                url: "{{ url('check_customer_number') }}/" + val,
                type: "GET",
                data: {
                    number: val
                },
                dataType: 'json',
                success: function(result) {
                    if (result.getCell == true) {
                        alert('Customer already exists!');

                    }
                }
            });
        })
    </script>
@endpush
