@extends('layouts.master')

@push('css')
@endpush

@section('content')
<?php //echo "<pre>"; print_r($po_data); exit(); ?>
<style type="text/css">
    .tborder {border: 1px solid black !important;}
    table.customtble tbody tr td{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 13px;
        color: gray;

    }
    table.customtble thead tr th{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 14px;
        font-weight: bold;
    }
    @media print{
        table.customtble thead tr th{
            font-size: 11px;
        }
        table.customtble tbody tr td{
            font-size: 10px;
        }
        body * { visibility: hidden; margin-top: 0px !important;}
        .printableArea, .printableArea *{ visibility: visible !important; }
        table{ border-collapse: collapse;}
        @page {size: landscape}
    }
</style>
<div class="container-fluid">
    <div class="printableArea" id="printableArea">
        <form id="FormId" class="form-horizontal" method="POST" action="{{ route('saleReportDetail') }}">
            {{ csrf_field() }}
            <div class="form-horizontal form-body hidden-print">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">

                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="brand_id" class="col-sm-4 control-label">Brands</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="brand_id" id="brand_id" onchange="getCategories(this.value);">
                                                    <option value="">Please Select</option>
                                                    <?php if(isset($brands) && !empty($brands)){ foreach($brands as $row){ ?>
                                                    <option value="<?php echo $row['id_brands']; ?>"><?php echo $row['brand_name']; ?></option>
                                                    <?php }} ?>
                                                </select>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="category_id" class="col-sm-4 control-label">Categories</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="category_id" id="category_id" onchange="getProducts(this.value);"></select>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="product_id" class="col-sm-4 control-label">Products</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="product_id" id="product_id"></select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-4 control-label">From Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="fromdate" id="fromdate" class="form-control" autocomplete="false" value="" />
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-4 control-label">To Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="todate" id="todate" class="form-control" autocomplete="false" value="" />
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-1 col-lg-1 col-sm-1 col-xs-12 col-sm-offset-10 col-lg-offset-10 col-md-offset-10 text-right">
                                        <span class="spin-loader"></span>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="submitbutton" type="button" class="btn btn-primary"><i class="fa fa-search"></i> Run</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">

                    <div class="panel-body">
                        <div class="clearfix">
                            <div class="pull-left ">
                                <!-- <h3 class="logo invoice-logo"><img src='{{asset('plugins/images/'.$business->business_logo)}}' width="200" alt='logo here' /></h3> -->
                            </div>
                        </div>
                        <hr class="hidden">
                        <div class="row">
                            <div class="col-md-12"><h3 class="text-center">Sales Report (Detail)</h3></div>
                        </div>
                        <div class="row hidden">
                            <div class="col-md-12">
                                <table style=" width: 100%;" cellspacing="0" id="podetailstbl" class="customtble">
                                    <tr>
                                        <td style="width: 50% ">
                                            <p><strong>From </strong>: <span id="fromdateshow"><?php echo date('d-M-Y', strtotime($fromdate)); ?></span>
                                                <br>
                                                <strong>To </strong>: <span id="todateshow"><?php echo date('d-M-Y', strtotime($todate)); ?></span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                        <td style="width: 0.5%; border-bottom: none !important; border-top: none !important;"></td>
                                        <td style="width: 50%">
                                            <p><strong>Statement Date: </strong> <?php echo date('d-M-Y'); ?>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                    </tr>
                                </table>

                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="m-h-50">&nbsp;</div>
                        <div class="row hidden">
                            <div class="col-md-12">
                                <div class="btn-group m-r-10">
                                    <button data-toggle="dropdown" class="btn btn-default btn-outline dropdown-toggle waves-effect waves-light" type="button">
                                        Show/Hide Columns <span class="caret"></span>
                                    </button>
                                    <ul role="menu" id="shCol" class="dropdown-menu animated lightSpeedIn icheck-list">

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkserial" value="0" >
                                                <label for="checkserial">#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkitem" value="1">
                                                <label for="checkitem">Item Name</label>
                                            </div>
                                        </li>

                                         <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkarticle" value="2">
                                                <label for="checkarticle">Article#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checksaleman" value="3">
                                                <label for="checksaleman">SalesMan</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checksaleorder" value="4">
                                                <label for="checksaleorder">Sale Order#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checktrans" value="5">
                                                <label for="checktrans">Trans#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checktransdate" value="6">
                                                <label for="checktransdate">Trans Date</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkqty" value="7">
                                                <label for="checkqty">Qty</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkunitprice" value="8">
                                                <label for="checkunitprice">Unit Price</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkdiscountpercent" value="9">
                                                <label for="checkdiscountpercent">Discount %</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checktotalamount" value="10">
                                                <label for="checktotalamount">Amount</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkdiscountrupees" value="11">
                                                <label for="checkdiscountrupees">Discount (Rs)</label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checknetamount" value="12">
                                                <label for="checknetamount">Net Amount</label>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="m-h-50">&nbsp;</div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <!-- <table class="table table-bordered m-t-30" id="tblproducts"> -->
                                    <!-- <table id="tblreport" class="table table-bordered customtble"> -->
                                    <table id="tblreport" class="display nowrap table-bordered" cellspacing="0" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Item Name</th>
                                                <th>Category</th>
                                                <th>Sku</th>
                                                <th>Sales Man</th>
                                                <th>Sale Order#</th>
                                                <th>GDN#</th>
                                                <th>GDN Date</th>
                                                <th>Qty</th>
                                                <th>Return Qty</th>
                                                <th>Unit Price</th>
                                                <th>Amount</th>
                                                <th>Customer Discount %</th>
                                                <th class="hidden">Discount Amount</th>
                                                <th>Discounted Price</th>
                                                <th>Invoice Discount %</th>
                                                <th>Return Amount</th>
                                                <th>Net Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody><tr><td>Data not found</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="hidden"></td><td></td><td></td><td></td></tr></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <div class="hidden-print">
                            <div class="pull-right">
                                <a id="printbutton" href="#" class="btn btn-inverse waves-effect waves-light hidden" onclick='window.print();'  ><i class="fa fa-print"></i></a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
</div>
<script>
    $(document).ready(function(){
        var return_net_amount = 0;
        $('#tblreport').DataTable({
            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
            stateSave: false,
            fixedHeader: {header: true},
            "bSort" : false,
            dom: "Bfrtlip",
            buttons: [
                {extend: "excel", title: 'Sale Report Detail', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
                {extend: "pdf", title: '<?php echo $business->business_name; ?>\n (Sale Report Detail)', orientation: 'landscape', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
            ],
            scrollX: false,
            //responsive: !0
        });

        $('#fromdate').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: "dd-mm-yyyy",
//                viewMode: "months",
//                minViewMode: "months"
        });

        $('#todate').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: "dd-mm-yyyy",
        });
        $('#category_id, #product_id').select2();
        $('#brand_id').select2();
        var shTable;
        $('#submitbutton').click(function(){
            $('.spin-loader').addClass('fa fa-spin fa-spinner');
            $('#fromdateshow').html('').html($('#fromdate').val());
            $('#todateshow').html('').html($('#todate').val());
            if($('#brand_id option:selected').val() == ''){
                $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                swal({
                    title: "Please select Brand!",
                    type: "info",
                    confirmButtonText: 'OK!'
                });
                return false;
            }
            $.ajax({
                type: 'POST',
                url: $('#FormId').attr('action'),
                data: {fromdate: $('#fromdate').val(), todate: $('#todate').val(), category_id: $('#category_id option:selected').val(), brand_id: $('#brand_id option:selected').val(), product_id: $('#product_id option:selected').val()},
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
                },
                success: function(response){
                    var data = response;
                    var body = '';
                    var return_qty = 0;
                    var customer_name = '',amount = 0;
                    var grand_total_qty = 0, grand_total_return_qty = 0, grand_unit_price = 0, grand_amount = 0, grand_unit_discount = 0, grand_netamount = 0, grand_discount_amount = 0, invoice_net_amount = 0 , returned_amount= 0;
                    var total_qty = 0, total_unit_price = 0, total_amount = 0, total_unit_discount = 0, total_netamount = 0, discount_amount = 0, grand_invoice_net_amount = 0 , grand_return_amount = 0;
                    var hhtml = '<tr><th>#</th><th>Item Name</th><th>Category</th><th>Sku</th><th>Sales Man</th><th>Sale Order#</th><th>GDN#</th><th>GDN Date</th>  <th>Qty</th> <th>Return Qty</th>  <th>Unit Price</th><th>Amount</th><th>Customer Discount %</th><th class="hidden">Discount Amount</th><th>Discounted Price</th><th>Invoice Discount %</th><th>Return Amount</th><th>Net Amount</th></tr>';
                    for(var i = 0; i < data.length; i++){
                        grand_amount += parseFloat(data[i]['qty']) * parseFloat(data[i]['gdn_unit_price']);
                        grand_amount -= parseFloat(data[i]['returned_qty']) * parseFloat(data[i]['gdn_unit_price']);
                        grand_total_qty += parseFloat(data[i]['qty']);
                        grand_total_return_qty += parseFloat(data[i]['returned_qty']);
                        grand_unit_price += parseFloat(data[i]['gdn_unit_price']);
                        //grand_discount_amount += parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100);
                        grand_discount_amount += parseFloat(data[i]['qty'])*((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100);
                        grand_unit_discount += parseFloat(data[i]['gdn_discount_percent']);
                        grand_netamount += parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100));

                        var u = (parseFloat(data[i]['returned_qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)));
                        var x = (parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)));
                        var y = data[i]['extra_discount_amount'];
                        grand_invoice_net_amount += x - ((x * y) / 100);
                        grand_return_amount  += u - ((u * y) / 100);
                        if(data[i]['customer_name'] != customer_name){
                            if(amount != 0){//amount variable is only using for if condition should skip first row
                                //This row is only adding for each customer amount record
                                body += '<tr><td></td><td></td><td></td> <td></td><td></td><td></td><td></td><td class="text-right"><strong>Total: </strong></td><td class="text-right">'+total_qty.toFixed(2)+'</td><td class="text-right">'+return_qty.toFixed(2)+'</td><td class="text-right"></td><td class="text-right">'+addCommas(total_amount.toFixed(2))+'</td><td class="text-right"></td><td class="text-right hidden">'+addCommas(discount_amount.toFixed(2))+'</td><td class="text-right">'+addCommas(total_netamount.toFixed(2))+'</td><td></td><td class="text-right">'+addCommas(return_net_amount.toFixed(2))+'</td><td class="text-right">'+addCommas(invoice_net_amount.toFixed(2))+'</td></tr>';
                            }
                            body += '<tr><td></td><td><strong>Customer Name: </strong>'+data[i]['customer_name']+'</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="hidden"></td><td></td><td></td><td></td><td></td><td></td></tr>';
                            amount = 0;
                            total_qty = 0;
                            return_qty = 0;
                            return_net_amount = 0;
                            total_unit_price = 0;
                            discount_amount = 0;
                            total_unit_discount = 0;
                            total_netamount = 0;
                            total_amount = 0;
                            invoice_net_amount = 0;
                            returned_amount = 0;
                        }

                        total_amount += parseFloat(data[i]['qty']) * parseFloat(data[i]['gdn_unit_price']);
                        amount += parseFloat(data[i]['gdn_unit_price']);
                        total_qty += parseFloat(data[i]['qty']);
                        return_qty += parseFloat(data[i]['returned_qty']);
                        total_unit_price += parseFloat(data[i]['gdn_unit_price']);
                        //discount_amount += parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100);
                        discount_amount += parseFloat(data[i]['qty'])*((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100);
                        total_unit_discount += parseFloat(data[i]['gdn_discount_percent']);
                        total_netamount += parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100));

                        var j = (parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)));
                        var k = data[i]['extra_discount_amount'];
                        var return_amount =(parseFloat(data[i]['returned_qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)));
                        return_net_amount +=return_amount - ((return_amount * k) / 100) ;
                        invoice_net_amount += j - ((j * k) / 100)-return_amount;

                        body += '<tr>';
                        body += '<td>'+(i+1)+'</td>';
                        body += '<td>'+data[i]['product_name']+'</td>';
                        body += '<td>'+data[i]['category_name']+'</td>';
                        body += '<td>'+data[i]['sku']+'</td>';
                        body += '<td>'+data[i]['employee_name']+'</td>';
                        body += '<td>'+data[i]['sale_order_number']+'</td>';
                        body += '<td>'+data[i]['gdn_number']+'</td>';
                        body += '<td>'+data[i]['transdate']+'</td>';
                        body += '<td class="text-right">'+data[i]['qty']+'</td>';
                        body += '<td class="text-right">'+data[i]['returned_qty']+'</td>';
                        body += '<td class="text-right">'+addCommas(parseFloat(data[i]['gdn_unit_price']).toFixed(2))+'</td>';
                        body += '<td class="text-right">'+addCommas((data[i]['gdn_unit_price'] * data[i]['qty']).toFixed(2))+'</td>';
                        body += '<td class="text-right">'+addCommas(data[i]['gdn_discount_percent'])+'</td>';
                        //body += '<td class="text-right">'+addCommas((parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)).toFixed(2))+'</td>';
                        body += '<td class="text-right hidden">'+addCommas((((data[i]['qty'] * parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)).toFixed(2))+'</td>';

                        body += '<td class="text-right">'+addCommas(((parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)))- return_amount).toFixed(2))+'</td>';

                        //na = net amount, extra_discount_amount = invoice discount
                        var na = (parseFloat(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100)));
                        var extra_discount_amount = data[i]['extra_discount_amount'];
                        var t = na - ((na * extra_discount_amount) / 100) - return_amount;
                        body += '<td class="text-right">'+extra_discount_amount+'</td>';
                        body += '<td class="text-right">'+addCommas(return_amount.toFixed(2))+'</td>';
                        body += '<td class="text-right">'+t.toFixed(2)+'</td>';
                        body += '</tr>';
                        customer_name = data[i]['customer_name'];
                    }
                    //This row is only adding for last customer amount record
                    body += '<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="text-right"><strong>Total: </strong></td><td class="text-right">'+total_qty.toFixed(2)+'</td><td class="text-right">'+return_qty.toFixed(2)+'</td><td class="text-right"></td><td class="text-right">'+addCommas(total_amount.toFixed(2))+'</td><td class="text-right"></td><td class="text-right hidden">'+addCommas(discount_amount.toFixed(2))+'</td><td class="text-right">'+addCommas(total_netamount.toFixed(2))+'</td><td></td><td class="text-right">'+addCommas(return_net_amount.toFixed(2))+'</td><td class="text-right">'+addCommas((invoice_net_amount).toFixed(2))+'</td></tr>';

                    //This rows are only adding for grand total of all customer
                    body += '<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>&nbsp;</td><td>&nbsp;</td><td></td><td></td><td></td><td></td></tr>';
                    body += '<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="text-right"><strong>Grand Total: </strong></td><td class="text-right">'+grand_total_qty.toFixed(2)+'</td><td class="text-right">'+grand_total_return_qty.toFixed(2)+'</td><td class="text-right"></td><td class="text-right">'+addCommas(grand_amount.toFixed(2))+'</td><td class="text-right"></td><td class="text-right hidden">'+addCommas(grand_discount_amount.toFixed(2))+'</td><td class="text-right">'+addCommas(grand_netamount.toFixed(2))+'</td><td></td><td class="text-right">'+addCommas(grand_return_amount.toFixed(2))+'</td><td class="text-right">'+addCommas(grand_invoice_net_amount.toFixed(2))+'</td></tr>';
                    if(data.length > 0){
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        var heading = '<tr><td></td><td><strong>Sale Report (Detail)</strong></td><td><strong>Brand</strong>: '+$('#brand_id option:selected').text()+'</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="hidden"></td><td></td><td></td><td></td><td></td><td></td></tr>';
                        var date = '<tr><td></td><td><strong>From: </strong>'+$('#fromdate').val()+'<strong> To: </strong>'+$('#todate').val()+'</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="hidden"></td><td></td><td></td><td></td><td></td><td></td></tr>';
                        var tbody = heading+date+body;
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append(tbody);

                        shTable = $('#tblreport').DataTable({
                            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                            stateSave: false,
                            fixedHeader: {header: true},
                            "bSort" : false,
                            dom: "Bfrtlip",
                            buttons: [
                                {extend: "excel", title: 'Sale Report Detail', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
                                {extend: "pdf", title: '<?php echo $business->business_name; ?>\n (Sale Report Detail)', orientation: 'landscape', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
                            ],
                            scrollX: false,
                            //responsive: !0
                        });
                    }else{
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append('<tr><td>Data not found</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td class="hidden"></td><td></td><td></td><td></td><td></td><td></td></tr>');
                        $('#printbutton').addClass('hidden');
                        $('#tblreport').DataTable({
                            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                            stateSave: false,
                            fixedHeader: {header: true},
                            "bSort" : false,
                            dom: "Bfrtlip",
                            buttons: [
                                {extend: "excel", title: 'Sale Report Detail', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
                                {extend: "pdf", title: '<?php echo $business->business_name; ?>\n (Sale Report Detail)', orientation: 'landscape', filename: 'saleReportDetail', exportOptions: { columns: ':visible' }},
                            ],
                            scrollX: false,
                            //responsive: !0
                        });
                    }
                }
            });
        });

        jQuery('#shCol input').on('click', function() {
            // Get the column API object
            var column = shTable.column($(this).val());
            // Toggle the visibility
            if ($(this).is(':checked')){
                column.visible(true);
            }else{
                column.visible(false);
            }
        });
    });
    function addCommas(nStr)
{
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}

    function getCategories(brand_id){
        $('.spin-loader').addClass('fa fa-spin fa-spinner');
        if(brand_id == ''){
            $('#category_id').html('');
            $('.spin-loader').removeClass('fa fa-spin fa-spinner');
            return false;
        }else{
            $.ajax({
                type: 'POST',
                url: '<?php echo url('categoryBrand'); ?>',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
                },
                dataType: 'json',
                data: {brand_id: brand_id},
                success: function(response){
                    var category = '';
                    var categories = response;
                    for(var i = 0; i < categories.length; i++){
                        category += '<option value='+categories[i]['type_id']+'>'+categories[i]['type_name']+'</option>';
                    }
                    if(categories.length > 0){
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        category = '<option value="all">All</option>'+category;
                        $('#category_id').html('').append(category);
                    }else{
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        $('#category_id').html('').append('<option value=0>Data not found</option>');
                    }
                }
            });
        }

        setTimeout(function(){ getProducts($('#category_id option:selected').val()); }, 1000);
    }

    function getProducts(category_id){
        $('.spin-loader').addClass('fa fa-spin fa-spinner');
        if(category_id == ''){
            $('#product_id').html('');
            $('.spin-loader').removeClass('fa fa-spin fa-spinner');
            return false;
        }else{
            $.ajax({
                type: 'POST',
                url: '<?php echo url('getProductByCategory'); ?>',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
                },
                dataType: 'json',
                data: {category_id: category_id, brand_id: $('#brand_id option:selected').val()},
                success: function(response){
                    var product = '';
                    var products = response['products'];
                    for(var i = 0; i < products.length; i++){
                        product += '<option value='+products[i]['id_products']+'>'+products[i]['product_name']+'</option>';
                    }
                    if(products.length > 0){
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        product = '<option value="all">All</option>'+product;
                        $('#product_id').html('').append(product);
                    }else{
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        $('#product_id').html('').append('<option value=0>Data not found</option>');
                    }
                }
            });
        }
    }
</script>
@endsection

