@extends('layouts.master')

@php
    $units = App\MeasurementUnit::where('id_measurement_unit', $product->measurement_unit_id)->first();
@endphp

@section('content')
    <div class="az-content-breadcrumb">
        <span>Products Stock</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Stock List
        <span>
            @can('Stocks add')
                <a href="{{ route('products.stocks.create', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product_id)]) }}"
                    class="btn btn-az-primary" style="float: right"><i class="fa-solid fa-plus"></i> Add New Stock</a>
            @endcan
            @can('Products list')
                <a href="{{ route('products.list', Crypt::encrypt($product->brands_id)) }}" class="btn border"
                    style="float: right">
                    <i class="fa-solid fa-bars-staggered"></i> Back to Products
                </a>
            @endcan
        </span>
    </h2>
    <div class="row my-3">
        <div class="col-md-6 col-lg-6 col-xl-6">
            <div class="profile-card bg-light shadow rounded p-4">
                <section id="personal-info">
                    <h2 class="mb-4" style="color: #00beda;">Product Information</h2>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Product Name:</label>
                            <span><strong>{{ $product->products_name }}</strong></span>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Price:</label>
                            <strong>{{ $product->products_sale_price }}</strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Unit:</label>
                            <strong>{{ $units ? $units->measurement_unit_name : 'N/A' }}</strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Overall Stock:</label>
                            <strong>{{ $product->in_stock ? $product->in_stock : '0' }}</strong>
                        </h5>
                    </div>
                    <div class="mb-3 d-flex align-items-center">
                        <h5>
                            <label class="fw-bold text-muted me-2">Brand Name:</label>
                            <strong>{{ $product->brand->brands_name }}</strong>
                        </h5>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Store Name</th>
                                <th class="wd-10p">Batches#</th>
                                <th class="wd-10p">Pur. Date</th>
                                <th class="wd-10p">Expires</th>
                                <th class="wd-10p">Purchase Qty</th>
                                <th class="none">Customer Return</th>
                                <th class="wd-10p">Transfer In</th>
                                <th class="wd-10p">Transfer Out</th>
                                <th class="wd-10p">Sold</th>
                                <th class="none">Supplier Return</th>
                                <th class="none">Damage</th>
                                <th class="none">Remain Qty</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $color = $product->products_status == 0 ? '#f5c5c5' : '';
                            @endphp
                            @foreach ($product->stocks as $key => $stock)
                                <tr style="background-color: {{ $color }};">
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ optional($stock->store)->store_name ?? 'N/A' }}</td>
                                    <td>{{ $stock->stock_batch_number ?? 'N/A' }}</td>
                                    <td>{{ date('d-m-Y', strtotime($stock->stock_purchase_date)) ?? 'N/A' }}</td>
                                    <td>{{ date('d-m-Y', strtotime($stock->stock_expiry_date)) ?? 'N/A' }}</td>
                                    <td>{{ $stock->stock_purchase_qty ?? '0' }}</td>
                                    <td>{{ $stock->stock_customer_return ?? '0' }}</td>
                                    <td>{{ $stock->stock_qty_to_transfer_in ?? '0' }}</td>
                                    <td>{{ $stock->stock_qty_to_transfer_out ?? '0' }}</td>
                                    <td>{{ $stock->stock_sold_qty ?? '0' }}</td>
                                    <td>{{ $stock->stock_supplier_return ?? '0' }}</td>
                                    <td>{{ $stock->stock_damage_qty ?? '0' }}</td>
                                    <td>{{ $stock->stock_remain_qty ?? '0' }}</td>
                                    <td>
                                        @can('Stocks edit')
                                            <a class="btn rounded shadow-base" title="Edit Stock"
                                                href="{{ route('products.stocks.edit', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)]) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                    class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('Stocks increase')
                                            <a class="btn rounded shadow-base" title="Add More Stock Quantity"
                                                href="{{ route('products.stocks.increase', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)]) }}">
                                                <i class="text-info fa-solid fa-plus"></i> <span class="text-info">Increase
                                                    Stock</span>
                                            </a>
                                        @endcan
                                        @can('Stocks transfer')
                                            <a class="btn rounded shadow-base" title="Stock Transfer"
                                                href="{{ route('products.stocks.edit', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)]) }}">
                                                <i class="text-muted fa-solid fa-right-left"></i> <span
                                                    class="text-muted">Transfer</span>
                                            </a>
                                        @endcan
                                        @can('Stocks damage')
                                            <a class="btn rounded shadow-base" title="Remove the stock"
                                                href="{{ route('products.stocks.damage', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($stock->products_id)]) }}">
                                                <img src="{{ asset('stock-damaged.png') }}" alt="Add Damaged Stock"
                                                    style="height: 18px; width: auto; margin-bottom: 4px;"> <span
                                                    class="text-danger">Damage</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-10p">Store Name</th>
                                <th class="wd-10p">Batches#</th>
                                <th class="wd-10p">Pur. Date</th>
                                <th class="wd-10p">Expires</th>
                                <th class="wd-10p">Purchase Qty</th>
                                <th class="none">Customer Return</th>
                                <th class="wd-10p">Transfer In</th>
                                <th class="wd-10p">Transfer Out</th>
                                <th class="wd-10p">Sold</th>
                                <th class="none">Supplier Return</th>
                                <th class="none">Damage</th>
                                <th class="none">Remain Qty</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: true,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
@endpush
