<?php

namespace App\Http\Controllers;

use App\Discounts;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class DiscountsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //     $this->middleware(function ($request, $next) {
    //         $this->role_id = Auth::user()->role_id;
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         $ex = explode('/', $request->path());
    //         if (count($ex) >= 3) {
    //             $sliced = array_slice($ex, 0, -1);
    //         } else {
    //             $sliced = $ex;
    //         }

    //         $string = implode("/", $sliced);
    //         //                 dd($string);
    //         if (checkConstructor($this->role_id, count($ex) >= 3 ? $string . '/' : $string) == 1) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'store') !== false) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'update') !== false) {
    //             return $next($request);
    //         } else {
    //             abort(404);
    //         }
    //     });

    // }

    public function index()
    {
        //
        $discounts = Discounts::all();
        // $discounts = Discounts::all()
        // ->join('users as u', 'u.id', 'po.created_by');
        $discounts = DB::table('discounts')
            ->join('users', 'users.id', 'discounts.created_by')
            ->select('discounts.*', 'users.name')->get();
        // dd($discounts);
        return view('discounts.index', compact('discounts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $discounts = Discounts::all();
        return view('discounts.create', compact('discounts'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $store = new Discounts();
        $store->discount_name = $request->discount_name;
        $store->discount_type = $request->discount_type;
        $store->discount_for = $request->discount_for;
        $store->discount_price = $request->discount_price;
        $store->discount_status = $request->discount_status;

        // dd($store);
        // $store->discount_status = "1";
        $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Discounted Added Successfully");

        return redirect('discounts');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Discounts  $discounts
     * @return \Illuminate\Http\Response
     */
    // public function show(Discounts $discounts)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Discounts  $discounts
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = Discounts::where('id_discounts', $dec_id)->first();
        // $edit = currency_exchange_rate::all();

        return view('discounts.edit', compact('edit'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Discounts  $discounts
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        $update = Discounts::where('id_discounts', $dec_id)->first();
        $update->discount_name = $request->discount_name;
        $update->discount_type = $request->discount_type;
        $update->discount_for = $request->discount_for;
        $update->discount_price = $request->discount_price;
        $update->discount_status = $request->discount_status;
        // dd($store);
        // $update->discount_status = "1";
        $update->created_by = auth()->user()->id;

        $update->save();
        session()->flash('info', " Discount Updated Successfully");

        return redirect('discounts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Discounts  $discounts
     * @return \Illuminate\Http\Response
     */
    // public function destroy(Discounts $discounts)
    // {
    //     //
    // }
    public function destroy($id)
    {
        $Discounts = Discounts::findOrFail($id);
        $Discounts->delete();
        session()->flash('warning', "Discount Removed!");
        return redirect()->back();
    }
}
