<?php

namespace App\Http\Controllers;

use App\Employees;
use App\Http\Controllers\Controller;
use GPBMetadata\Google\Api\Auth;
use Illuminate\Http\Request;

class EmployeesController extends Controller
{
    // public function check_role_permission()
    // {
    //     $get_role_id = auth()->user()->role_id;
    //     $noti_create_inquiry = role_permission::where('role_id', $get_role_id)->where('menu_id', 103)->first();
    //     $noti_create_quotation = role_permission::where('role_id', $get_role_id)->where('menu_id', 103)->first();
    //     if ($noti_create_inquiry) {
    //         $noti_array[] = 'self_inquiry';
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "create_quotation";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "send_quotation_to_approval";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "inquiry_remarks";
    //     } elseif ($noti_create_quotation) {
    //         $noti_array[] = "quotation_remarks";
    //     } else {
    //         $noti_array = [];
    //     }
    //     return  $noti_array;
    // }

    public function index()
    {
        $employee = Employees::all();
        return view('Employees.index', compact('employee'));
    }
    public function create()
    {
        $employee = Employees::all();
        return view('Employees.create', compact('employee'));
    }

    public function store(Request $request)
    {
        $store = new Employees();
        $store->employee_name = $request->employee_name;
        $store->employee_no = $request->employee_no;
        $store->employee_email = $request->employee_email;
        $store->employee_address = $request->employee_address;
        $store->status = $request->status;
        // $store->status = "1"; // It Means Active
        $store->employee_created_by = Auth()->User()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Employee Added Successfully");

        return redirect('employee');
    }

    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = Employees::where('id_employee', $dec_id)->first();
        // dd($edit);
        return view('Employees.edit', compact('edit'));
    }

    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        $update = Employees::where('id_employee', $dec_id)->first();
        $update->employee_name = $request->employee_name;
        $update->employee_no = $request->employee_no;
        $update->employee_email = $request->employee_email;
        $update->employee_address = $request->employee_address;
        $update->status = $request->status;
        $update->save();
        // dd($ update);

        session()->flash('info', "Employee Updated Successfully");

        return redirect('employee');
    }

    public function destroy($id)
    {
        $Employees = Employees::findOrFail($id);
        $Employees->delete();
        session()->flash('warning', "Employee Removed!");
        return redirect()->back();
    }
}
