<?php

namespace App\Http\Controllers;

use App\SaleRateApplication;
use App\Http\Controllers\Controller;
use App\GoodReceiptTruck;
use App\Sale;
use App\SalesItemDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class SalesRateApplicationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $sales = SaleRateApplication::with(['salesItemsDetails', 'salesPerBoriWeight', 'customer', 'goodReceiptTruck', 'goodReceiptTruck.goodReceiptDetails'])->get();
        return view('sale_rate_application.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $trucks = GoodReceiptTruck::with('goodReceipts.goodReceiptDetails')->get();
        return view('sale_rate_application.create', compact('trucks'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
    */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\SaleRateApplication  $saleRateApplication
     * @return \Illuminate\Http\Response
     */
    public function show(SaleRateApplication $saleRateApplication)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\SaleRateApplication  $saleRateApplication
     * @return \Illuminate\Http\Response
     */
    public function edit(SaleRateApplication $saleRateApplication)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\SaleRateApplication  $saleRateApplication
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SaleRateApplication $saleRateApplication)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\SaleRateApplication  $saleRateApplication
     * @return \Illuminate\Http\Response
     */
    public function destroy(SaleRateApplication $saleRateApplication)
    {
        //
    }

    public function getTruckDetails(Request $request)
    {
        $truckId = $request->get('truck_id');

        // Fetch the sales with the selected truck_id
        $sale = Sale::with('salesItemsDetails')
            ->where('good_receipts_truck_id', $truckId)
            ->first();

        if (!$sale) {
            return response()->json(['error' => 'No sales found for this truck'], 404);
        }

        // Return sale item details
        return response()->json([
            'client_name' => $sale->customer->customer_name, // Assuming you have a 'customer' relation
            'vehicle_no' => $sale->goodReceiptTruck->truck_no, // Assuming you have a 'goodReceiptTruck' relation
            'sales_items' => $sale->salesItemsDetails
        ]);
    }
    
    public function salesRateApply(Request $request)
    {
        $request->validate([
            'amount.*' => 'required|numeric',
            'notes.*' => 'nullable|string',
            'sales_item_detail_ids.*' => 'required|integer|exists:sales_items_details,id_sid',
            'sales_rate_date' => 'required|date',
        ]);

        $ids = $request->input('sales_item_detail_ids');
        $amounts = $request->input('amount');
        $notes = $request->input('notes');
        $rate_applied_on = $request->input('sales_rate_date');

        foreach ($ids as $index => $id) {
            $salesItemDetail = SalesItemDetail::findOrFail($id);
            $salesItemDetail->amount = $amounts[$index];
            $salesItemDetail->notes = $notes[$index];
            $salesItemDetail->rate_applied_on = $rate_applied_on;
            $salesItemDetail->save();
        }

        return redirect()->route('sale_rate.create')->with('success', 'Sales Rate Applied Successfully.');
    }


}
