<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalesItemDetail extends Model
{
    protected $primaryKey = 'id_sid';
    protected $table = 'sales_items_details';
    protected $fillable = [
        'sales_id',
        'good_detail_id',
        'items_name',
        'items_main_cate',
        'items_parent_cate',
        'items_child_cate',
        'marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'notes',
        'status',
        'rate_applied_on',
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sales_id');
    }

    // public function salesPerBoriWeight()
    // {
    //     return $this->hasMany(SalesPerBoriWeight::class, 'sales_items_details_id');
    // }
}
