@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Control Account</span>
    </div>

    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="az-content-title" style="display: inline">Control Account List</h2>
            <nav aria-label="breadcrumb" class="mt-3">
                <ol class="breadcrumb bg-transparent p-2  border rounded">
                    <li class="breadcrumb-item">
                        <a href="{{ url('main_account') }}" class="text-decoration-none text-dark">
                            <i class="fas fa-home me-1"></i> Main Account List
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-primary" aria-current="page">
                        <i class="fas fa-folder-open me-1"></i> {{ $main_account->main_account_name }}
                    </li>
                </ol>
            </nav>
        </div>
        <span>
            @can('Control Account add')
                    <a href="javascript:window.history.back()" class="btn btn-outline-secondary me-2">
                        <i class="fas fa-arrow-left me-1"></i> Back to Main Account
                    </a>
                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fas fa-plus me-1"></i> Add Account
                </button>
            @endcan
        </span>
    </div>
    <div class="card card-body pd-20">
        <div class="row">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div>
                    <table id="example2" class="table">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            {{-- {{dd($main_account)}} --}}
                            @foreach ($control_account as $key => $m_acc)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $m_acc->control_account_number }}</td>
                                    <td>{{ $m_acc->control_account_name }}</td>
                                    <td>{{ $m_acc->ca_urdu_name }}</td>

                                    <td>{{ $m_acc->created_at }}</td>
                                    <td>
                                        @can('Sub Control Account list')
                                            <a class="btn rounded shadow-base text-info"
                                                href="{{ url('sub_control_account/' . $main_account->id_main_account . '/' . $m_acc->id_control_account) }}">
                                                <i class="fa-solid fa-arrow-up-right-from-square"></i>
                                                <strong>Sub Control Account</strong>
                                            </a>
                                        @endcan
                                        @can('Control Account edit')
                                            <a type="button" class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#exampleModal2" data-id="{{ $m_acc->id_control_account }}"
                                                data-name="{{ $m_acc->control_account_name }}"
                                                data-urdu-name="{{ $m_acc->ca_urdu_name }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <strong class="text-primary">Edit</strong>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('control_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_main_account" name="id_main_account"
                                value="{{ $main_account->id_main_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name <span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <br>
                        <div class="form-group">
                            <label class=" " style="float: inline-end;"> <span style="color:red;">*</span>
                                کھا تہ
                            </label>
                            <input type="text" name="ca_urdu_name" class="form-control" id="ca_urdu_name_add"
                                dir="rtl" />
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Sub Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_control_account" name="id_control_account"
                                value="{{ $main_account->id_main_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label class=" " style="float: inline-end;">
                                کھا تہ
                            </label>
                            <input type="text" name="ca_urdu_name" class="form-control" id="ca_urdu_name_edit"
                                dir="rtl" />

                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        $('#exampleModal2').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Button that triggered the modal
            var id = button.data('id'); // Extract info from data-* attributes
            var name = button.data('name');
            var urduName = button.data('urdu-name'); // Extract Urdu name

            var modal = $(this);
            modal.find('#id_sub_control_account').val(id);
            modal.find('#name').val(name);
            modal.find('#ca_urdu_name_edit').val(urduName); // Set the Urdu name in the input field

            // Set the form action dynamically if needed
            modal.find('#addMainAccountForm').attr('action', "{{ url('transaction_account/update') }}/" + id);
        });
        document.getElementById('ca_urdu_name_add').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            // Remove any character that doesn't match the Urdu pattern
            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
        document.getElementById('ca_urdu_name_edit').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            // Remove any character that doesn't match the Urdu pattern
            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
    </script>
    <script type="text/javascript">
        $('#exampleModal2').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Button that triggered the modal
            var id = button.data('id'); // Extract info from data-* attributes
            var name = button.data('name');

            var modal = $(this);
            modal.find('#editForm').attr('action', '{{ url('control_account/update') }}/' + id);
            modal.find('#name').val(name);
        });

        // $(function() {



        //     oTable = $('#example2').DataTable({

        //         responsive: !0
        //     });



        // });
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Control Account Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Control Account Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Control Account Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Control Account Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });
    </script>
@endpush
