<?php

namespace App\Http\Controllers;

use App\Brands;
use App\Supplier;
use App\Http\Controllers\Controller;
use App\supplier_brand;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SupplierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $suppliers = Supplier::all();
        return view('supplier.index', compact('suppliers'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $supplier = Supplier::all();
        return view('supplier.create', compact('supplier'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request);
        $store = new Supplier();
        $store->supplier_name = $request->supplier_name;
        $store->supplier_name_urdu = $request->supplier_name_urdu;
        $store->supplier_email = $request->email;
        $store->supplier_address = $request->address;
        $store->supplier_address_urdu = $request->supplier_address_urdu;
        $store->contact_person = $request->contact_person;
        $store->phone_1 = $request->phone_1;
        $store->phone_2 = $request->phone_2;
        $store->website = $request->website;
        $store->status = $request->status;
        $store->opening_bal_dr = $request->blance_dr;
        $store->opening_bal_cr = $request->blance_cr;
        $store->opening_date = $request->opening_date;

        // $store->status = '1';

        // dd($store);
        $store->save();
        session()->flash('success', "New Supplier Added Successfully");

        return redirect('supplier/list');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function show(Supplier $supplier)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = Supplier::where('id_supplier', $dec_id)->first();
        // dd($edit);
        // $edit = currency_exchange_rate::all();

        return view('supplier.edit', compact('edit'));
    }

    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        $update = Supplier::where('id_supplier', $dec_id)->first();
        $update->supplier_name = $request->supplier_name;
        $update->supplier_name_urdu = $request->supplier_name_urdu;
        $update->supplier_email = $request->email;
        $update->supplier_address = $request->address;
        $update->supplier_address_urdu = $request->supplier_address_urdu;
        $update->contact_person = $request->contact_person;
        $update->phone_1 = $request->phone_1;
        $update->phone_2 = $request->phone_2;
        $update->website = $request->website;
        $update->status = $request->status;
        $update->opening_bal_dr = $request->blance_dr;
        $update->opening_bal_cr = $request->blance_cr;
        $update->opening_date = $request->opening_date;
        $update->save();
        session()->flash('info', "Supplier Updated Successfully");

        return redirect('supplier/list');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Supplier = Supplier::find($id);
        $Supplier->delete();
        session()->flash('warning', "Supplier Removed");
        return redirect()->back();
    }

    public function brand($id)
    {
        $dec_id = \Crypt::decrypt($id);

        // Fetch supplier and associated brands
        $supplier = Supplier::where('id_supplier', $dec_id)->first();

        // Retrieve the brands associated with the supplier
        $supplier_brands = DB::table('supplier_brand')
            ->leftJoin('brands', 'supplier_brand.brand_id', '=', 'brands.id_brands')
            ->leftJoin('supplier', 'supplier_brand.supplier_id', '=', 'supplier.id_supplier')
            ->where('supplier.id_supplier', $dec_id)
            ->select('supplier_brand.*', 'supplier.supplier_name', 'brands.brands_name')
            ->get();


        // dd($supplier_brands);

        return view('supplier.supplier_brands', compact('supplier_brands', 'supplier'));
    }

    public function brand_create($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $supplier = Supplier::where('id_supplier', $dec_id)->first();
        $brands = Brands::all();
        return view('supplier.brands_create', compact('brands', 'supplier'));
    }

    public function brand_store(Request $request)
    {
        $request->validate([
            'brand' => 'required|exists:brands,id_brands',
            'supplier' => 'required|exists:supplier,id_supplier',
        ]);

        $exists = supplier_brand::where('brand_id', $request->brand)
            ->where('supplier_id', $request->supplier)
            ->exists();

        if ($exists) {
            session()->flash('warning', 'Brand already assigned to supplier.');
        } else {
            $store = new supplier_brand();
            $store->brand_id = $request->brand;
            $store->supplier_id = $request->supplier;
            $store->save();
            session()->flash('success', 'Brand assigned to supplier successfully.');
        }

        return redirect()->back();
    }

    public function brand_destroy($id)
    {
        $supplier_brand = supplier_brand::find($id);
        if ($supplier_brand) {
            $supplier_brand->delete();
            session()->flash('warning', "Supplier's Brand Removed");
        } else {
            session()->flash('error', "Supplier's Brand Not Found");
        }
        return redirect()->back();
    }
}
