@extends('layouts.master')
@section('content')
  
    <div class="az-content-breadcrumb">
        <span>Supplier</span>
        <span>Add Supplier </span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Supplier <span>
            <a href="{{ route('supplier.brand', \Crypt::encrypt($supplier->id_supplier)) }}" class="btn btn-az-primary"
                style="float: right">Brands List</a></span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Supplier</h5>
                <form method="post" action="{{ route('supplier.brand_store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Supplier Name</label>
                                <select class="form-control" name="supplier_display" id="" disabled
                                    style="display: block; color: #000;">
                                    <option value="{{ $supplier->id_supplier }}">{{ $supplier->supplier_name }}</option>
                                </select>
                                <input type="hidden" name="supplier" value="{{ $supplier->id_supplier }}">

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Brand</label>
                                <select class="form-control select2" name="brand" id="brandSelect">
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id_brands }}">{{ $brand->brands_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <a type="button" href="{{ route('supplier.list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            $('#brandSelect').select2({
                theme: 'default'
            });
        });
    </script>
@endpush
