<?php

namespace App\Http\Controllers;

use App\ServicePurchase;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class ServicePurchaseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $service = ServicePurchase::all();
        return view('service_purchase.index', compact('service'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('service_purchase.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request data
        $request->validate([
            'unit_id' => 'required|string|max:255',
            'ser_purchase_sp_no' => 'nullable|string|max:255',
            'ser_purchase_vechile_no' => 'nullable|string|max:255',
            'ser_purchase_bill_no' => 'nullable|string|max:255',
            'ser_purchase_expense' => 'nullable|string|max:255',
            'ser_purchase_qty' => 'nullable|string|max:255',
            'ser_purchase_unit' => 'nullable|string|max:255',
            'ser_purchase_price' => 'nullable|string|max:255',
            'ser_purchase_amount' => 'nullable|string|max:255',
            'ser_purchase_remarks' => 'nullable|string|max:255',
            'supplier_id' => 'nullable|string|max:255',
            'ser_purchase_status' => 'required|in:1,0'

        ]);



        // Create a new brand record
        ServicePurchase::create([
            'unit_id' => $request->unit_id,
            'ser_purchase_sp_no' => $request->ser_purchase_sp_no,
            'ser_purchase_vechile_no' => $request->ser_purchase_vechile_no,
            'ser_purchase_bill_no' => $request->ser_purchase_bill_no,
            'ser_purchase_expense' => $request->ser_purchase_expense,
            'ser_purchase_qty' => $request->ser_purchase_qty,
            'ser_purchase_unit' => $request->ser_purchase_unit,
            'ser_purchase_price' => $request->ser_purchase_price,
            'ser_purchase_amount' => $request->ser_purchase_amount,
            'ser_purchase_remarks' => $request->ser_purchase_remarks,
            'supplier_id' => $request->supplier_id,
            'created_by' => auth()->user()->name,
            'ser_purchase_status' => $request->ser_purchase_status,
        ]);

        // Redirect back with success message
        return redirect()->route('service_purchase.list')->with('success', 'Service Purchase created successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ServicePurchase  $service
     * @return \Illuminate\Http\Response
     */
    public function show(ServicePurchase $service)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ServicePurchase  $service
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $decryptedId = Crypt::decrypt($id);
        $service = ServicePurchase::findOrFail($decryptedId);
        // dd($service);
        return view('service_purchase.edit', compact('service'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ServicePurchase  $service
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'unit_id' => 'required|string|max:255',
            'ser_purchase_sp_no' => 'nullable|string|max:255',
            'ser_purchase_vechile_no' => 'nullable|string|max:255',
            'ser_purchase_bill_no' => 'nullable|string|max:255',
            'ser_purchase_expense' => 'nullable|string|max:255',
            'ser_purchase_qty' => 'nullable|string|max:255',
            'ser_purchase_unit' => 'nullable|string|max:255',
            'ser_purchase_price' => 'nullable|string|max:255',
            'ser_purchase_amount' => 'nullable|string|max:255',
            'ser_purchase_remarks' => 'nullable|string|max:255',
            'supplier_id' => 'nullable|string|max:255',
            'ser_purchase_status' => 'required|in:1,0'
        ]);

        $decryptedId = Crypt::decrypt($id);
        $service = ServicePurchase::where('id_ser_purchase', $decryptedId)->first();

        if ($service) {
            $service->update([
                'unit_id' => $request->unit_id,
                'ser_purchase_sp_no' => $request->ser_purchase_sp_no,
                'ser_purchase_vechile_no' => $request->ser_purchase_vechile_no,
                'ser_purchase_bill_no' => $request->ser_purchase_bill_no,
                'ser_purchase_expense' => $request->ser_purchase_expense,
                'ser_purchase_qty' => $request->ser_purchase_qty,
                'ser_purchase_unit' => $request->ser_purchase_unit,
                'ser_purchase_price' => $request->ser_purchase_price,
                'ser_purchase_amount' => $request->ser_purchase_amount,
                'ser_purchase_remarks' => $request->ser_purchase_remarks,
                'supplier_id' => $request->supplier_id,
                'created_by' => auth()->user()->name,
                'ser_purchase_status' => $request->ser_purchase_status,
            ]);

            return redirect()->route('service_purchase.list')->with('success', 'Service purchase updated successfully.');
        } else {
            return redirect()->route('service_purchase.list')->with('error', 'Service purchase not found.');
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ServicePurchase  $service
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        {
            // Decrypt the ID
            $id_ser_purchase = Crypt::decrypt($id);

            // Find the brand or return 404 if not found
            $service = ServicePurchase::find($id_ser_purchase);
            if (!$service) {
                return abort(404);
            }

            // Delete the brand record
            $service->delete();
            // Redirect back with success message
            return redirect()->route('service_purchase.list')->with('success', 'Service Purchase deleted successfully!');
        }
    }
}
