<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stocks extends Model
{
//    use HasFactory;

    protected $primaryKey = 'id_stock';
    protected $table = 'stocks';
    protected $fillable = [
        'products_id',
        'store_id',
        'stock_batch_number',
        'stock_damage_qty',
        'stock_damage_date',
        'stock_purchase_date',
        'stock_expiry_date',
        'stock_batch_type',
        'stock_manual_add_qty',
        'stock_remain_qty',
        'stock_purchase_qty',
        'stock_qty_to_transfer',
        'stock_purchase_price',
        'stock_remarks',
        'stock_status',
    ];

    public function product()
    {
        return $this->belongsTo(Products::class, 'products_id');
    }

    public function store()
    {
        return $this->belongsTo(Stores::class, 'store_id');
    }
}
