@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Transaction Account</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="az-content-title" style="display: inline">Transaction Account List</h2>
            <nav aria-label="breadcrumb" class="mt-3">
                <ol class="breadcrumb bg-transparent p-2  border rounded">
                    <li class="breadcrumb-item">
                        <a href="{{ url('main_account') }}" class="text-decoration-none text-dark">
                            <i class="fas fa-home me-1"></i>Main Account List
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-dark" aria-current="page">
                        <a href="{{ url('control_account/' . $main_account->id_main_account) }}"
                            class="text-decoration-none text-dark"><i class="fas fa-folder-open me-1"></i>
                            {{ $main_account->main_account_name }}
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-dark" aria-current="page">
                        <a href="{{ url('sub_control_account/' . $main_account->id_main_account . '/' . $control_account->id_control_account) }}" class="text-decoration-none text-dark">
                            <i class="fas fa-folder-open me-1"></i> {{ $control_account->control_account_name }}
                        </a>
                    </li>

                    <li class="breadcrumb-item active text-primary" aria-current="page">
                        <i class="fas fa-folder-open me-1"></i> {{ $sub_control_account->sub_control_account_name }}
                    </li>
                </ol>
            </nav>
        </div>
        <span>
            @can('Transaction Action add')
            <a href="javascript:window.history.back()" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-1"></i>
                    Back to Sub Control Account
                </a>
                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i> Add Account
                </button>
            @endcan
        </span>
    </div>
    <div class="card card-body pd-20">

        <div class="row">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div>
                    <table id="example2" class="table ">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Title</th>
                                <th class="wd-10p">کھاتہ</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($transaction_account as $key => $m_acc)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $m_acc->transaction_account_number }}</td>
                                    <td>{{ $m_acc->transaction_account_name }}</td>
                                    <td>{{ $m_acc->tacc_urdu_name }}</td>
                                    <td>{{ $m_acc->status }}</td>
                                    <td>{{ $m_acc->created_at }}</td>
                                    <td>
                                        @can('Transaction Action edit')
                                            <a type="button" class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#exampleModal2" data-id="{{ $m_acc->id_transaction_account }}"
                                                data-name="{{ $m_acc->transaction_account_name }}"
                                                data-tacc_urdu_name="{{ $m_acc->tacc_urdu_name }}"
                                                data-account_type="{{ $m_acc->account_type }}"
                                                data-status="{{ $m_acc->status }}">

                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <strong class="text-primary">Edit</strong> </a>
                                        @endcan
                                        @can('Transaction Action delete')
                                            <a href="#" class="btn rounded shadow-base " data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ $m_acc->id_transaction_account }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <strong class="text-danger">Remove</strong>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Title</th>
                                <th class="wd-10p">کھاتہ</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Transaction Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('transaction_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_sub_control_account"
                                name="id_sub_control_account" value="{{ $sub_control_account->id_sub_control_account }}"
                                required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <br>
                        <div class="form-group">
                            <label class=" " style="float: inline-end;">
                                کھا تہ
                            </label>
                            <input type="text" name="tacc_urdu_name" class="form-control" id="tacc_urdu_name_add"
                                dir="rtl" />
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="accountName">Status</label>
                            {{-- <input type="text" class="form-control" id="status" name="status" required> --}}
                            <select class="form-control" name="status" id="status">
                                <option value="Active">Active</option>
                                <option value="Inactive">In Active</option>
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="accountName">Account type</label>
                            <select class="form-control" name="acc_type" id="acc_type">
                                <option value="Bank">Bank</option>
                                <option value="Cash">Cash</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="text-white btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Transaction Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="accountName">Main Account ID</label>
                            <input type="text" class="form-control" id="id_sub_control_account"
                                name="id_sub_control_account" required>
                        </div>
                        <div class="form-group">
                            <label for="accountName">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <br>
                        <div class="form-group">
                            <label class=" " style="float: inline-end;">
                                کھا تہ
                            </label>
                            <input type="text" name="tacc_urdu_name" class="form-control" id="tacc_urdu_name_edit"
                                dir="rtl" />
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="accountName">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="Active">Active</option>
                                <option value="Inactive">Inactive</option>
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="accountName">Account Type</label>
                            <select class="form-control" name="account_type" id="account_type">
                                <option value="Bank">Bank</option>
                                <option value="Cash">Cash</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="text-white btn btn-secondary" data-dismiss="modal">Close</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    </div>
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Transaction account?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script type="text/javascript">
        document.getElementById('tacc_urdu_name_edit').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            // Remove any character that doesn't match the Urdu pattern
            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
        document.getElementById('tacc_urdu_name_add').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            // Remove any character that doesn't match the Urdu pattern
            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
        $('#exampleModal2').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Button that triggered the modal
            var id = button.data('id'); // Extract info from data-* attributes
            var name = button.data('name');
            var tacc_urdu_name = button.data('tacc_urdu_name');
            var status = button.data('status');
            var account_type = button.data('account_type');

            var modal = $(this);
            modal.find('#id_sub_control_account').val(id);
            modal.find('#name').val(name);
            modal.find('#tacc_urdu_name').val(tacc_urdu_name);
            modal.find('#status').val(status);
            modal.find('#account_type').val(account_type);

            // Set the form action dynamically
            modal.find('#addMainAccountForm').attr('action', "{{ url('transaction_account/update') }}/" + id);
        });

        // $(function() {
        //     oTable = $('#example2').DataTable({

        //         responsive: !0
        //     });
        // });

        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Transactioin Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Transactioin Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Transactioin Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Transactioin Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });


        $('#deleteModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var id = button.data('id');
            var actionUrl = '{{ url('transaction_account/delete') }}/' + id;
            var modal = $(this);
            modal.find('#deleteForm').attr('action', actionUrl);
        });
    </script>
@endpush
