@extends('layouts.master')

@section('content')

    <style>
        @font-face {
            font-family: 'Jameel Noori Nastaleeq';
            src: url('path/to/JameelNooriNastaleeq.woff') format('woff'),
                url('path/to/JameelNooriNastaleeq.ttf') format('truetype');
        }

        .az-content-label-ur {
            font-family: 'Jameel Noori Nastaleeq', serif;
            font-size: 2.5vh;

            margin-bottom: 15px;
            line-height: 1;
        }
    </style>
    <!-- Breadcrumb and Page Title -->
    <div class="az-content-breadcrumb">
        <span>Goods Receipts</span>
        <span>Add Goods Receipts</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Goods Receipts
        <span>
            <a href="{{ route('good_receipts.list') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to List
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Goods Receipts</h5>
                <form method="post" action="{{ route('good_receipts.store') }}">
                    @csrf
                    <!-- Error Display -->
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Basic Details -->
                    <div class="row row-sm mg-b-20">
                        <!-- Date, PNo, Truck Number -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label" for="goods_date">Date</label>
                                <input type="date" name="goods_date" class="form-control" required />
                            </div>
                            @error('goods_date')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label">PNo</label>
                                <input type="text" name="p_no" class="form-control" />
                            </div>
                            @error('p_no')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{-- <label class="az-content-label">Truck Number</label> --}}
                                <label class="az-content-label-ur " style="float: inline-end;"><b> ٹرک نمبر</b></label>

                                <input type="text" name="truck_number" class="form-control" required />
                            </div>
                            @error('truck_number')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>

                    <!-- uppliers, Builty Number, Rent Received -->
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                {{-- <label class="az-content-label">Suppliers</label> --}}
                                <label class="az-content-label-ur " style="float: inline-end;"><b>سپلائرز </b></label>

                                <select class="form-control select2" name="suppliers" id="suppliers" required>
                                    <option value="">- Select -</option>
                                    @foreach ($suppliers as $key => $supplier)
                                        <option value="{{ $supplier->id_supplier }}">{{ $supplier->supplier_name }} -
                                            {{ $supplier->supplier_name_urdu }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('suppliers')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{-- <label class="az-content-label">Builty Number</label> --}}
                                <label class="az-content-label-ur " style="float: inline-end;"><b> بلٹی نمبر </b></label>
                                <input type="text" name="builty_number" class="form-control" />
                            </div>
                            @error('builty_number')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{-- <label class="az-content-label" for="rent_received">Rent Received</label> --}}
                                <label class="az-content-label-ur " style="float: inline-end;"><b>کرایہ وصول</b></label>

                                <input type="text" name="rent_received" id="rent_received" class="form-control" />
                            </div>
                            @error('rent_received')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>

                    <!-- Details -->
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600" for="goods_status">Status</label>
                            <select id="goods_status" name="goods_status" class="form-control">
                                <option value="">Select</option>
                                <option value="1" {{ old('goods_status') == '1' ? 'selected' : '' }}>Active
                                </option>
                                <option value="0" {{ old('goods_status') == '0' ? 'selected' : '' }}>
                                    In-Active
                                </option>
                            </select>
                            @error('goods_status')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                {{-- <label class="az-content-label">Details</label> --}}
                                <label class="az-content-label-ur " style="float: inline-end;"><b> تفصیلات </b></label>


                                <textarea class="form-control" name="details" id="details" cols="30" rows="10"></textarea>
                            </div>
                            @error('details')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>

                    <!-- Items Section -->
                    <hr class="my-5">
                    <div id="items-wrapper">
                        <div class="row row-sm mg-b-20 shadow p-3 bg-light rounded" id="item-row-0">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="az-content-label">Items</label>
                                    <input type="text" name="items[]" class="form-control" required />
                                </div>
                                @error('items')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="az-content-label">Marka</label>
                                    <input type="text" name="marka[]" class="form-control" />
                                </div>
                                @error('marka')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label class="az-content-label">Bori</label>
                                    <input type="number" name="bori[]" class="form-control" />
                                </div>
                                @error('bori')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label class="az-content-label">Weight</label>
                                    <input type="number" name="weight[]" class="form-control" />
                                </div>
                                @error('weight')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label class="az-content-label">Rate</label>
                                    <input type="number" name="rate[]" class="form-control" />
                                </div>
                                @error('rate')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="az-content-label">Remarks</label>
                                    <textarea class="form-control" name="remarks[]" cols="30" rows="10"></textarea>
                                </div>
                                @error('remarks')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Add More Button -->
                    <div class="row">
                        <div class="col-lg-12">
                            <button type="button" class="btn btn-az-primary btn-block mt-2" id="add-more">
                                <span class="mdi mdi-arrow-expand-up"></span> Add More
                            </button>
                        </div>
                    </div>

                    {{-- Show Total --}}
                    <div class="row row-sm mg-b-20 mt-5">
                        <div class="col-12">
                            <h3 style="line-height: 2.5rem;">
                                <span>
                                    Total Bori: <span id="total-bori">0</span>
                                </span>
                                <br>
                                <span>
                                    Total Weight: <span id="total-weight">0</span>
                                </span>
                            </h3>
                        </div>
                    </div>

                    <!-- Submit and Cancel Buttons -->
                    {{-- <div class="mt-5">
                        <a type="button" href="{{ url('unit_type') }}" class="btn btn-danger btn-block mt-2">
                            Cancel
                        </a>
                        <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                            Submit
                        </button>
                    </div> --}}
                    <a href="{{ route('good_receipts.list') }}" class="btn btn-danger pd-x-20">Cancel</a>
                    <button type="submit" class="btn btn-az-primary pd-x-20">Save</button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#suppliers').select2({
                theme: 'default'
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            let itemIndex = 1;

            // Function to calculate and update total bori and weight
            function calculateTotals() {
                let totalBori = 0;
                let totalWeight = 0;

                document.querySelectorAll('input[name="bori[]"]').forEach(function(boriInput) {
                    totalBori += parseFloat(boriInput.value) || 0;
                });

                document.querySelectorAll('input[name="weight[]"]').forEach(function(weightInput) {
                    totalWeight += parseFloat(weightInput.value) || 0;
                });

                document.getElementById('total-bori').innerText = totalBori;
                document.getElementById('total-weight').innerText = totalWeight;
            }

            // Event listener to recalculate totals when bori or weight fields are changed
            document.getElementById('items-wrapper').addEventListener('input', function(event) {
                if (event.target.name === 'bori[]' || event.target.name === 'weight[]') {
                    calculateTotals();
                }
            });

            // Function to add a new item row
            document.getElementById('add-more').addEventListener('click', function() {
                let newRow = document.getElementById('item-row-0').cloneNode(true);
                newRow.id = 'item-row-' + itemIndex;
                newRow.addClass = 'mt-5';

                // Reset the input fields in the cloned row
                newRow.querySelectorAll('input, textarea').forEach(function(input) {
                    input.value = '';
                });

                // Create the "Remove" trash icon
                let removeIcon = document.createElement('i');
                removeIcon.className = 'fa fa-trash-alt text-light remove-item bg-danger p-2 rounded-1';
                removeIcon.style.cursor = 'pointer';
                removeIcon.style.float = 'right';
                removeIcon.style.marginTop = '10px';

                // Add event to remove the current row and recalculate totals
                removeIcon.addEventListener('click', function() {
                    this.closest('.row').remove();
                    calculateTotals();
                });

                // Append the "Remove" icon to the new row
                let actionCol = document.createElement('div');
                actionCol.className = 'col-md-12';
                actionCol.appendChild(removeIcon);
                newRow.appendChild(actionCol);

                document.getElementById('items-wrapper').appendChild(newRow);
                itemIndex++;
            });
        });
    </script>
@endpush
