<?php

namespace App\Http\Controllers;

use App\Chart_of_account;
use App\control_account;
use App\main_account;
use App\Sub_control_account;
use App\transaction_account;
use Illuminate\Http\Request;

class Chart_of_accountController extends Controller
{

    public function main_account()
    {
        $main_account = main_account::all();
        return view('Chart_of_account.main_account', compact('main_account'));
    }

    public function main_account_store(Request $request)
    {
        $lastMainAccount = main_account::orderBy('id_main_account', 'desc')->first();

        $newAccountNumber = $lastMainAccount ? sprintf('%02d', $lastMainAccount->main_account_number + 1) : '1';

        $store = new main_account();
        $store->main_account_number = $newAccountNumber;
        $store->main_account_name = $request->name;
        $store->save();
        return redirect()->back()->with('success', 'Main Account added successfully!');
    }


    public function control_account($id)
    {
        $main_account = main_account::findOrFail($id);

        $control_account = control_account::where('main_account_id', $main_account->id_main_account)
            ->get();

        // dd($control_account);
        return view('Chart_of_account.control_account', compact('control_account', 'main_account'));
    }

    public function control_account_store(Request $request)
    {
        $lastMainAccount = control_account::where('main_account_id', $request->id_main_account)
            ->orderBy('id_control_account', 'desc')->first();

        $newAccountNumber = $lastMainAccount ? sprintf('%02d', $lastMainAccount->control_account_number + 1) : '1';

        $store = new control_account();
        $store->main_account_id = $request->id_main_account;
        $store->control_account_number = $newAccountNumber;
        $store->control_account_name = $request->name;
        // dd($store);
        $store->save();

        return redirect()->back()->with('success', 'Main Account added successfully!');
    }

    public function control_account_update(Request $request, $id)
    {

        $update = control_account::where('id_control_account', $id)->first();
        $update->control_account_name = $request->name;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Sub Control Account Updated successfully!');
    }



    public function sub_control_account($c_id, $id)
    {
        $main_account = main_account::findOrFail($c_id);

        $control_account = control_account::where('main_account_id', $main_account->id_main_account)
            ->where('id_control_account', $id)
            ->firstOrFail();

        $sub_control_accounts = sub_control_account::where('control_account_id', $control_account->id_control_account)
            ->get();

        // dd($main_account);

        return view('Chart_of_account.sub_control_account', compact('sub_control_accounts', 'control_account'));
    }

    public function sub_control_account_store(Request $request)
    {
        $lastSubControlAccount = sub_control_account::where('control_account_id', $request->id_control_account)
            ->orderBy('id_sub_control_account', 'desc')
            ->first();

        $newAccountNumber = $lastSubControlAccount ? sprintf('%02d', $lastSubControlAccount->sub_control_account_number + 1) : '1';

        $store = new sub_control_account();
        $store->control_account_id = $request->id_control_account;
        $store->sub_control_account_number = $newAccountNumber;
        $store->sub_control_account_name = $request->name;
        $store->save();

        return redirect()->back()->with('success', 'Sub Control Account added successfully!');
    }

    public function sub_control_account_update(Request $request, $id)
    {

        $update = sub_control_account::where('id_sub_control_account', $id)->first();
        $update->sub_control_account_name = $request->name;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Sub Control Account Updated successfully!');
    }

    public function destroy_sub_control_account($id)
    {
        $transactionAccount = transaction_account::where('sub_control_account_id', $id)->get();

        if ($transactionAccount->isEmpty()) {
            $subControlAccount = sub_control_account::findOrFail($id);
            $subControlAccount->delete();

            return redirect()->back()->with('success', 'Sub Control Account deleted successfully!');
        } else {
            return redirect()->back()->with('warning', 'Sub Control Account has Transaction accounts!');
        }
    }

    public function transaction_account($id)
    {
        $sub_control_account = sub_control_account::findOrFail($id);

        // dd($sub_control_account);
        $transaction_account = transaction_account::where('sub_control_account_id', $sub_control_account->id_sub_control_account)
            ->get();

        return view('Chart_of_account.transaction_account', compact('transaction_account', 'sub_control_account'));
    }

    public function transaction_account_store(Request $request)
    {
        $lastSubControlAccount = transaction_account::orderBy('transaction_account_number', 'desc')->first();

        $newAccountNumber = $lastSubControlAccount ? sprintf('%02d', $lastSubControlAccount->transaction_account_number + 1) : '1';
        $store = new transaction_account();
        $store->sub_control_account_id = $request->id_sub_control_account;
        $store->transaction_account_number = $newAccountNumber;
        $store->transaction_account_name = $request->name;
        $store->status = $request->status;
        $store->account_type = $request->acc_type;
        // dd($store);

        $store->save();



        return redirect()->back()->with('success', 'Transaction Account Updated successfully!');
    }

    public function transaction_account_update(Request $request, $id)
    {

        $update = transaction_account::where('id_transaction_account', $id)->first();
        $update->transaction_account_name = $request->name;
        $update->status = $request->status;
        $update->account_type = $request->account_type;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Main Account added successfully!');
    }
    public function destroy_transaction_account($id)
    {

        $transaction_account = transaction_account::findOrFail($id);
        $transaction_account->delete();

        return redirect()->back()->with('success', 'Transaction Account deleted successfully!');
    }
}
