@extends('layouts.master')
@section('content')
    <style>
        .iti.iti--allow-dropdown.iti--show-flags {
            width: 100%;
        }
    </style>
    <div class="az-content pd-y-20 pd-lg-y-30 pd-xl-y-40">
        <div class="container">
            <div class="az-content-body pd-lg-l-40 d-flex flex-column">

                <div class="az-content-breadcrumb">
                    <span>Customer list</span>
                    <span>Edit Customer</span>
                    {{-- <span>Forms</span> --}}
                    {{-- <span>Form Layouts</span> --}}
                </div>
                <h2 class="az-content-title" style="display: inline">Edit Customer <span><a href="{{ url('customers') }}"
                            class="btn btn-az-primary" style="float: right">Customer List</a></span></h2>
                <div class="row">
                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="card card-body pd-40">
                            <h5 class="card-title mg-b-20">Edit Customer Details</h5>
                            <form method="post" enctype="multipart/form-data"
                                action="{{ url('customers/update/' . \Crypt::encrypt($customers->id_customers)) }}">
                                @if (count($errors) > 0)
                                    <div class="p-1">
                                        @foreach ($errors->all() as $error)
                                            <div class="alert alert-warning alert-danger fade show" role="alert">
                                                {{ $error }}
                                                <button type="button" class="close" data-dismiss="alert"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                                <div class="row">
                                    <input type="hidden" name="c_id"
                                        value="{{ \Crypt::encrypt($customers->id_customers) }}">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Customer
                                                Name <span style="color:red;">*</span></label>
                                            <input type="text" value="{{ $customers->customer_name }}"
                                                name="customer_name" class="form-control" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Customer Number
                                                <span style="color:red;">*</span>
                                                &nbsp;&nbsp;&nbsp;
                                            </label>
                                            <input type="tel" id="phone0" class="form-control" required="required"
                                                name="customer_phone_1" value="{{ $customers->customer_phone1 }}">
                                            <div class="invalid-feedback0"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ">
                                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Contact - Other /
                                                PTCL / WHATSAPP</label>
                                            <input type="tel" value="{{ $customers->customer_phone2 }}" id="phone2"
                                                class="form-control" name="customer_phone_2">
                                            <div class="invalid-feedback2"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="form-group ml-2 mt-2">
                                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Customer
                                                    Address</label>
                                                <input type="text" value="{{ $customers->customer_address }}"
                                                    name="customer_address" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row ">
                                    <div class="col-md-6 ">
                                        <div class="form-group ml-2 mt-2">
                                            <div class="form-group">
                                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Customer
                                                    Email</label>
                                                <input value="{{ $customers->customer_email }}" type="text"
                                                    name="customer_email" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group ml-2 mt-2">
                                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                                            <select name="status" class="form-control" required="required">
                                                <option value="1" {{ $customers->status == '1' ? 'selected' : '' }}>Active</option>
                                                <option value="0" {{ $customers->status == '0' ? 'selected' : '' }}>In-Active</option>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>

                                        <!-- form-group -->
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <hr>
                                        <div class="form-group ml-2 mt-2">
                                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Customer
                                                Image</label>
                                            <input type="file" class="form-control" name="customer_image" />
                                        </div>
                                    </div>
                                    {{-- <h3 class="text-center mt-3">Add Care Of</h3> --}}

                                </div>
                                @csrf

                                <!-- form-group -->


                                <!-- form-group -->



                        </div>
                        <button onclick="history.back()" class="btn btn-danger btn-block mt-2">
                            Back
                        </button>
                        <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                            Update
                        </button>
                        </form>
                        <!-- card -->
                    </div>
                    <!-- col -->
                </div>
                {{-- </div><!-- az-content-body --> --}}
            </div>
        </div><!-- container -->
    </div><!-- az-content -->

@endsection

@push('scripts')
    <script>
        // Get Already Customer
        $("#phone0").on("keyup change", function(e) {
            let val = $(this).val();

            $.ajax({
                url: "{{ url('check_customer_number') }}/" + val,
                type: "GET",
                data: {
                    number: val
                },
                dataType: 'json',
                success: function(result) {
                    if (result.getCell == true) {
                        alert('Customer already exists!');

                    }
                }
            });
        })
    </script>
@endpush
