@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>General Ledger</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Ledger List</h2>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Insert Details</h5>
                @if (Session('alert'))
                    <div class="alert alert-card alert-<?php echo Session('alert-class'); ?>" role="alert">
                        <?php echo Session('alert'); ?>
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    </div>
                @endif
                <form action="{{ route('search.ledgers') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="from_date">
                                        From Date
                                    </label>
                                    <input type="date" name="from_date" id="from_date" class="form-control"
                                        value="{{ old('from_date') }}" />
                                    @error('from_date')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="cost_center_type">
                                        Cost Center Type:
                                    </label>
                                    <select id="cost_center_type" name="cost_center_type" class="form-control">
                                        <option value="all">All</option>
                                        <option value="Branches">Branches</option>
                                    </select>
                                    @error('cost_center_type')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="to_date">
                                        To Date
                                    </label>
                                    <input type="date" name="to_date" id="to_date" class="form-control"
                                        value="{{ old('to_date') }}" />
                                    @error('to_date')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="cost_center">
                                        Cost Center.
                                    </label>
                                    <input name="cost_center" id="cost_center" class="form-control"
                                        value="{{ old('cost_center') }}" />
                                    @error('cost_center')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="from_acc">
                                        From Acc.
                                    </label>
                                    <select id="from_acc" name="from_acc" class="form-control">
                                        <option value="all">All</option>
                                        <option value="Property">01-001-001 | Property</option>
                                    </select>
                                    @error('from_acc')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="business_partner">
                                        Business Partner:
                                    </label>
                                    <select id="business_partner" name="business_partner" class="form-control">
                                        <option value="all">All</option>
                                    </select>
                                    @error('business_partner')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="to_acc">
                                        To Acc.
                                    </label>
                                    <select id="to_acc" name="to_acc" class="form-control">
                                        <option value="all">All</option>
                                        <option value="Property">01-001-001 | Property</option>
                                    </select>
                                    @error('to_acc')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="business_name">
                                        Business Name.
                                    </label>
                                    <select id="business_name" name="business_name" class="form-control">
                                        <option value="all">All</option>
                                        <option value="Vendors">Vendors</option>
                                        <option value="Customers">Customers</option>
                                    </select>
                                    @error('business_name')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Run</button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
@endpush
