
<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>Supplier</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Supplier<span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Supplier add')): ?>
                <a href="<?php echo e(route('supplier.create')); ?>" class="btn btn-az-primary" style="float: right">Add Supplier</a>
            <?php endif; ?>
        </span>
    </h2>
    


    
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Supplier Name</th>
                            <th class="wd-10p">Supplier Email</th>
                            <th class="wd-10p">Supplier Address </th>
                            <th class="wd-10p">Contact Person </th>
                            <th class="wd-10p">Phone</th>
                            <th class="wd-10p">Website </th>
                            <th class="none">Status </th>
                            <th class="none">Created</th>
                            <th class="none">Operations</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($supplier->supplier_name); ?></td>
                                <td><?php echo e($supplier->supplier_email); ?></td>
                                <td><?php echo e($supplier->supplier_address); ?></td>
                                <td><?php echo e($supplier->contact_person); ?></td>
                                <td><?php echo e($supplier->phone_1); ?></td>
                                <td><?php echo e($supplier->website); ?></td>
                                <td>
                                    <?php if($supplier->status == 1): ?>
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    <?php else: ?>
                                        <span class="btn btn-rounded btn-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(date('d-m-Y', strtotime($supplier->created_at))); ?></td>
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Supplier edit')): ?>
                                        <a class="btn btn-az-primary"
                                            href="<?php echo e(route('supplier.edit', \Crypt::encrypt($supplier->id_supplier))); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Supplier delete')): ?>
                                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                            data-id="<?php echo e($supplier->id_supplier); ?>">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('supplier.brand', \Crypt::encrypt($supplier->id_supplier))); ?>"
                                        class="btn btn-success text-white">
                                        <i class="fas fa-plus"></i> Add Brand
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Supplier Name</th>
                            <th class="wd-10p">Supplier Email</th>
                            <th class="wd-10p">Supplier Address </th>
                            <th class="wd-10p">Contact Person </th>
                            <th class="wd-10p">Phone</th>
                            <th class="wd-10p">Website </th>
                            <th class="none">Status </th>
                            <th class="none">Created</th>
                            <th class="none">Operations</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <!-- card -->
        </div>
        <!-- col -->
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this sub-control account?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Brand Modal -->
    






    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete() {
            return confirm('Are you sure you want to delete this supplier?');
        }

        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '<?php echo e(url('supplier/destroy')); ?>/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });

        $(document).ready(function() {
            $('#brandModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var supplierId = button.data('id');
                var modal = $(this);
                modal.find('#supplier_id').val(supplierId);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/supplier/index.blade.php ENDPATH**/ ?>