
<?php $__env->startSection('content'); ?>
    <div class="az-content-breadcrumb">
        <span>RATE OF DISCOUNT</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Discounts <span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Discounts add')): ?>
                <a href="<?php echo e(url('discounts/create')); ?>" class="btn btn-az-primary" style="float: right">Add Discounts</a>
            <?php endif; ?>
        </span></h2>
    


    
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">Discount Name</th>
                            <th class="wd-10p">Discount Type</th>
                            <th class="wd-10p">Discount For</th>
                            <th class="wd-10p">Discount</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created</th>
                            <th class="col-2">Operations</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>

                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($discount->discount_name); ?></td>
                                <td><?php echo e($discount->discount_type); ?></td>
                                <td><?php echo e($discount->discount_for); ?></td>
                                <td><?php echo e($discount->discount_price); ?></td>
                                <td>
                                    <?php if($discount->discount_status == 1): ?>
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    <?php else: ?>
                                        <span class="btn btn-rounded btn-danger">In Active</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($discount->name); ?></td>
                                <td><?= date('d-m-Y', strtotime($discount->created_at)) ?></td>

                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Discounts edit')): ?>
                                        <a class="btn  btn-primary"
                                            href="<?php echo e(url('discounts/edit/' . \Crypt::encrypt($discount->id_discounts))); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Discounts delete')): ?>
                                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                            data-id="<?php echo e($discount->id_discounts); ?>">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Discount Name</th>
                            <th class="wd-10p">Discount Type</th>
                            <th class="wd-10p">Discount For</th>
                            <th class="wd-10p">Discount</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created</th>
                            <th class="col-2">Operations</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <!-- card -->
        </div>
        <!-- col -->
    </div>


    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Discount?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>



    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '<?php echo e(url('discounts/delete')); ?>/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\mds-scm\resources\views/discounts/index.blade.php ENDPATH**/ ?>