@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>B-Cheque</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        B-Cheque List
        <span>
            <a href="{{ route('b_cheque.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Create B-Cheque </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">PB No</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Total Amount</th>
                                <th class="wd-10p">Total Expanse</th>
                                <th class="wd-10p">Save Amount</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($b_cheques as $bCheque)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $bCheque->date }}</td>
                                    <td>{{ $bCheque->pb_no }}</td>
                                    <td>{{ $bCheque->goodReceiptTruck->truck_no ?? '' }}</td>
                                    <td>{{ $bCheque->bilty_no }}</td>
                                    <td>{{ $bCheque->supplier->supplier_name ?? 'N/A' }}</td>
                                    <td>
                                        <table class="table table-bordered">
                                            <tr>
                                                <th>Product</th>
                                                <th>Marka</th>
                                                <th>Quantity</th>
                                                <th>Weight</th>
                                                <th>Price</th>
                                                <th>Amount</th>
                                            </tr>
                                            @foreach ($bCheque->items as $item)
                                                <tr>
                                                    <td>{{ $item->item }}</td>
                                                    <td>{{ $item->marka }}</td>
                                                    <td>{{ $item->bori }}</td>
                                                    <td>{{ $item->weight }}</td>
                                                    <td>{{ $item->rate }}</td>
                                                    <td>{{ $item->amount }}</td>
                                                </tr>
                                            @endforeach
                                        </table>
                                    </td>
                                    <td>{{ $bCheque->details->total_amount ?? 'N/A' }}</td>
                                    <td>{{ $bCheque->details->total_expanse_amount ?? 'N/A' }}</td>
                                    <td>{{ $bCheque->details->save_amount ?? 'N/A' }}</td>
                                    <td>{{ $bCheque->created_by }}</td>
                                    <td>
                                        <a class="btn rounded shadow-base" title="Edit B-Cheque"
                                            href="{{ route('b_cheque.edit', Crypt::encrypt($bCheque->id_b_cheque)) }}">
                                            <i class="text-primary fa-regular fa-pen-to-square"></i>
                                            <span class="text-primary">Edit</span>
                                        </a>
                                        <a class="btn rounded shadow-base" title="Delete B-Cheque" data-toggle="modal"
                                            data-target="#deleteModal"
                                            data-id="{{ Crypt::encrypt($bCheque->id_b_cheque) }}">
                                            <i class="text-danger fa-solid fa-trash-can"></i>
                                            <span class="text-danger">Remove</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">PB No</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Total Amount</th>
                                <th class="wd-10p">Total Expanse Amount</th>
                                <th class="wd-10p">Save Amount</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this B-Cheque?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('b_cheque/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
