@extends('layouts.master')
@section('content')
<div class="az-content-breadcrumb no-print">
    <span>View {{ $voucherDetails->voucher_type }}</span>
</div>
<h2 class="az-content-title no-print" style="display: inline">
    <span class="no-print">View</span> {{ $voucherDetails->voucher_type }}
    <span class="no-print">
        <a href="javascript:history.back()" class="btn border" style="float: right"><i
                class="fa-solid fa-bars-staggered"></i>
            Back to {{ $voucherDetails->voucher_type }}
        </a>
    </span>
</h2>

<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12">
        <div class="card card-body pd-20">
            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-6">
                    <div>
                        <h5><strong>Voucher Type:</strong> {{ $voucherDetails->voucher_type }}</h5>
                        <h5><strong>Status:</strong> {{ $vou_other_detail->status }}</h5>
                        <h5><strong>Business Partner:</strong> {{ $vou_other_detail->partner_name }}</h5>
                        <h5><strong>Description:</strong> {{ $vou_other_detail->desciption }}</h5>
                    </div>
                </div>
                <div class="col-md-6">
                    <div style="float: inline-end">
                        <h5><strong>Voucher Number:</strong> <br>{{ $voucherDetails->voucher_number }}</h5>
                        <h5><strong>Voucher Date:</strong>
                            <br>{{ date('d-m-Y', strtotime($voucherDetails->created_at)) }}
                        </h5>
                    </div>
                </div>
            </div>
            <hr>
            <div class="mt-5">
                <table id="transactiontable" class="table table-hover table-bordered table-striped">
                    <thead>
                        <tr>
                            <th scope="col">Account Number</th>
                            <th scope="col">Account Title</th>
                            <th scope="col">Payment Mode</th>
                            <th scope="col">Instrument #</th>
                            <th scope="col">Cost Center</th>
                            <th scope="col">Remarks</th>
                            <th scope="col" class="text-primary">Debit</th>
                            <th scope="col" class="text-primary">Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $totalDebit = 0;
                        $totalCredit = 0; ?>
                        @foreach ($accountVouchers as $voucher)
                            <tr>
                                <td>{{ $voucher->account_no }}</td>
                                <td>{{ $voucher->account_title }}</td>
                                <td>{{ $voucher->payment_mode }}</td>
                                <td>{{ $voucher->instrument }}</td>
                                <td>{{ $voucher->cost_center_name }}</td>
                                <td>{{ $voucher->remarks }}</td>
                                <td>{{ $voucher->debit }}</td>
                                <td>{{ $voucher->credit }}</td>
                            </tr>
                            <?php $totalDebit += $voucher->debit;
                            $totalCredit += $voucher->credit; ?>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="6" class="text-right">Total</th>
                            <th>{{ number_format($totalDebit, 2) }}</th>
                            <th>{{ number_format($totalCredit, 2) }}</th>
                        </tr>
                    </tfoot>
                </table>
                <div class="no-print">
                    <a class="btn rounded shadow-base" title="Print Receipts Voucher" onclick="window.print()">
                        <i class="text-success fa-solid fa-print"></i>
                        <span class="text-success">Print</span>
                    </a>
                    <a class="btn rounded shadow-base" title="Edit Receipts Voucher"
                        href="{{ route('receipt_voucher.edit', \Crypt::encrypt($voucherDetails->id_vouchers_unique_number)) }}">
                        <i class="text-primary fa-solid fa-eye"></i>
                        <span class="text-primary">Edit</span>
                    </a>
                    {{-- <a class="btn rounded shadow-base" title="Delete Receipts Voucher" data-toggle="modal"
                        data-target="#deleteModal"
                        data-id="{{ Crypt::encrypt($voucherDetails->id_vouchers_unique_number) }}">
                        <i class="text-danger fa-solid fa-trash-can"></i>
                        <span class="text-danger">Remove</span>
                    </a> --}}
                </div>
            </div>
        </div>
    </div>
</div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('voucher/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
