<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Suppliers extends Model
{
    protected $primaryKey = 'id_supplier';
    protected $table = 'suppliers';
    protected $fillable = [
        'brand_id',
        'supplier_name',
        'supplier_name_urdu',
        'supplier_email',
        'supplier_address',
        'supplier_address_urdu',
        'contact_person',
        'phone_1',
        'phone_2',
        'website',
        'status',
        'opening_bal_dr',
        'opening_bal_cr',
        'opening_date',
    ];

    public function servicePurchases()
    {
        return $this->hasMany(ServicePurchase::class, 'supplier_id');
    }

    public function accounts()
    {
        return $this->hasMany(SupplierAccount::class, 'suppliers_id');
    }

    public function saleOrders()
    {
        return $this->hasMany(SupplierSaleOrder::class, 'suppliers_id');
    }

    public function paymentHistory()
    {
        return $this->hasMany(SupplierPaymentHistory::class, 'suppliers_id');
    }
}
