@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span> Paymet Voucher</span>
        <span>Add Paymet Voucher </span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Paymet Voucher <span>
                <a href="{{ route('paymet.list') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Paymet Voucher
            </a>
            </span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Create Paymet Voucher</h5>
                <hr>
                <form method="post" action="{{ route('paymet.store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row">
                        <!-- Left Column -->
                        <div class="col-md-6">
                            <div class="card shadow-sm">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="voucher_date" class="form-label"> Paymet Voucher Date</label>
                                        <input type="text" id="voucher_date" name="voucher_date" class="form-control"
                                            placeholder="Enter Voucher Date" required />

                                    </div>

                                    <div class="mb-3">
                                        <label for="description" class="form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description"></textarea>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- Right Column -->
                        <div class="col-md-6">
                            <div class="card shadow-sm">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="businessPartner" class="form-label">Business Partner</label>
                                        {{-- <input type="text" id="businessPartner" name="business_partner"
                                            class="form-control" placeholder="Enter Business Partner" required /> --}}
                                        <select onchange="getPO_Invoice();" id="business_type" name="business_type"
                                            class="form-control select2" data-select2-id="business_type" tabindex="-1"
                                            aria-hidden="true">
                                            <option value="selected">Select</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="partnerName" class="form-label">Partner Name</label>
                                        {{-- <input type="text" id="partnerName" name="partner_name" class="form-control"
                                            placeholder="Enter Partner Name" required /> --}}
                                        <select id="business_name" name="business_name" class="form-control select2"
                                            data-select2-id="business_name" tabindex="-1" aria-hidden="true">
                                            <option value="">Select</option>
                                        </select>
                                    </div>
                                    <div class="mb-3 text-center">
                                        <label class="form-label d-block">Payment Method</label>
                                        <div class="d-flex justify-content-center">
                                        <div class="me-3 text-center">
                                                <label class="form-label" for="cash">Cash</label>
                                                <div>
                                                    <input class="form-check-input" type="radio" id="cash"
                                                        name="payment_method" value="cash" required>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <label class="form-label" for="bank">Bank</label>
                                                <div>
                                                    <input class="form-check-input" type="radio" id="bank"
                                                        name="payment_method" value="bank" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Bottom Row -->
                    <div class="row my-4">
                        <div class="col-md-6">
                            <div class="card shadow-sm">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="transaction_type" class="form-label">Transaction Type</label>
                                        <select name="transaction_type" class="form-control" id="transaction_type">
                                            <option value="Credit">Credit</option>
                                            <option value="Debit">Debit</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="tax_debit" class="form-label">Tax Debit</label>
                                        <select name="tax_debit" class="form-control" id="tax_debit">
                                            <option value="No">No</option>
                                            <option value="Yes">Yes</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="transaction_account" class="form-label">Transaction Paymet</label>
                                        <select name="transaction_account" class="form-control select2"
                                            id="transaction_account">
                                            <option value="">123 | HBL</option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card shadow-sm">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="payment_mode" class="form-label">Payment Mode</label>
                                        <select name="payment_mode" class="form-control" id="payment_mode">
                                            <option value="Cash">Cash</option>
                                            <option value="Cheque">Cheque</option>
                                            <option value="Pay Order">Pay Order</option>
                                            <option value="Credit Card">Credit Card</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="amount" class="form-label">Amount</label>
                                        <input type="text" id="amount" name="amount" class="form-control"
                                            placeholder="Enter Amount" required />
                                    </div>
                                    <div class="mb-3">
                                        <label for="instrument" class="form-label">Instrument</label>
                                        <input type="text" id="instrument" name="instrument" class="form-control"
                                            placeholder="Enter Instrument" required />
                                    </div>
                                    <div class="mb-3">
                                        <label for="remarks" class="form-label">Remarks</label>
                                        <textarea id="remarks" name="remarks" class="form-control" placeholder="Enter Remarks"></textarea>
                                    </div>
                                    <button type="button" id="addButton"
                                        class="btn btn-success text-white mt-2 float-end">
                                        Add <i class="fas fa-arrow-down"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>


                    <br>
                    <div class="row mt-4">
                        <div class="col-12">
                            <table id="example2" class="table table-hover table-bordered align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th>Paymet Number</th>
                                        <th>Paymet Title</th>
                                        <th>Payment Mode</th>
                                        <th>Instrument #</th>
                                        <th>Amount</th>
                                        <th>Remarks</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th class="text-center">Status</th>
                                        <th>Created</th>
                                        <th class="text-center">Actions</th> <!-- Added Actions column -->
                                    </tr>
                                </thead>
                                <tbody id="voucherTableBody">
                                    <!-- Rows will be added dynamically here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        <i class="fa fa-save"></i> Save
                    </button>
                </form>
                <!-- col -->
            </div>
        </div>
    </div>


@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            $("#voucher_date").datepicker({
                dateFormat: "yy-mm-dd" // You can customize the date format here
            });
        });
        $(document).ready(function() {
            let counter = 1; // Counter for serial numbers

            $('#addButton').click(function() {
                // Get form data
                let voucherDate = $('#voucher_date').val();
                let transactionPaymet = $('select[name="transaction_account"] option:selected').text();
                let paymentMode = $('select[name="payment_mode"] option:selected').text();
                let instrument = $('#instrument').val();
                let amount = $('#amount').val();
                let remarks = $('#remarks').val();
                let transactionType = $('select[name="transaction_type"] option:selected').val();
                let voucherStatus = $('select[name="voucher_status"] option:selected').text();

                // Prepare Debit and Credit columns
                let debit = transactionType === 'Debit' ? amount : '';
                let credit = transactionType === 'Credit' ? amount : '';

                // Append new row to table
                $('#voucherTableBody').append(`
                <tr>
                    <td class="text-center">${counter++}</td>
                    <td>${transactionPaymet}</td>
                    <td>${transactionPaymet}</td>
                    <td>${paymentMode}</td>
                    <td>${instrument}</td>
                    <td>${amount}</td>
                    <td>${remarks}</td>
                    <td>${debit}</td>
                    <td>${credit}</td>
                    <td class="text-center">${voucherStatus}</td>
                    <td>${voucherDate}</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-danger btn-sm delete-row">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `);

                // Clear form fields after submission
                $('#voucherForm').trigger('reset');
            });

            // Delete row functionality
            $(document).on('click', '.delete-row', function() {
                $(this).closest('tr').remove();
            });
        });
    </script>
    </script>
@endpush
