@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Paymet Vooucher</span>
        <span>Edit Paymet Voucher</span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Paymet Voucher<span>
        <a href="{{ route('paymet.list') }}" class="btn border" style="float: right"><i
            class="fa-solid fa-bars-staggered"></i>
        Back to Paymet Voucher
    </a>
            </span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Paymet Voucher</h5>
                <form method="POST" action="{{ route('paymet.update', \Crypt::encrypt($edit->id_supplier)) }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Voucher Name</label>
                                <input type="text" name="supplier_name" value="{{ $edit->supplier_name }}"
                                    class="form-control" required />
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Email </label>
                                <input type="text" name="email" value="{{ $edit->supplier_email }}"
                                    class="form-control" />
                            </div>
                        </div>

                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Address </label>
                                <input type="text" name="address" value="{{ $edit->supplier_address }}"
                                    class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Contact Person</label>
                                <input type="text" name="contact_person" value="{{ $edit->contact_person }}"
                                    class="form-control" required />
                            </div>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Phone 1</label>
                                <input type="text" name="phone_1" value="{{ $edit->phone_1 }}" class="form-control"
                                    required />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Phone 2</label>
                                <input type="text" name="phone_2" value="{{ $edit->phone_2 }}" class="form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Website</label>
                                <input type="text" name="website" value="{{ $edit->website }}" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                                {{-- <input type="text" name="website" value="{{ $edit->sta }}" class="form-control"  /> --}}
                                <select class="form-control" name="status" id="">
                                    <option class="form-control" value="1">Active</option>
                                    <option class="form-control" value="0">In-Active</option>
                                </select>
                            </div>
                        </div>
                    </div>


                    <a type="button" href="{{ route('paymet.list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Update
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
    {{-- </div><!-- az-content-body --> --}}
@endsection
