@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Brands</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Brands List <span>
            @can('Brands add')
                <a href="{{ route('brands.create') }}" class="btn btn-az-primary" style="float: right"><i
                        class="fa-solid fa-plus"></i> Add New Brand </a></span>
        @endcan
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">

                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($brands as $key => $brand)
                                <?php
                                if (!empty($brand->brands_logo)) {
                                    $image = url('/uploads/brand_images/' . $brand->brands_logo);
                                } else {
                                    $image = url('/img/default_user.png');
                                }
                                ?>
                                <tr>

                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        <img src="<?= $image ?>" style="height:40px;width:40px;border-radius: 50%"
                                            alt="" srcset="">
                                    </td>
                                    <td>{{ $brand->brands_name }}</td>
                                    <td>{{ $brand->brands_abbrevation }}</td>
                                    <td>{{ $brand->created_by }}</td>
                                    <td><?= date('d-m-Y', strtotime($brand->created_at)) ?></td>
                                    <td>
                                        @if ($brand->brands_status == 1)
                                            <button class="btn btn-rounded btn-success" style="color:#fff;">
                                                <strong>Active</strong> <span class="badge badge-primary"></span>
                                            </button>
                                        @else
                                            <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                                <i class="fa-solid fa-ban"></i> <strong>Deactivated</strong> <span
                                                    class="badge badge-primary"></span>
                                            </button>
                                        @endif
                                    </td>
                                    <td>
                                        @can('Products list')
                                            <a class="btn btn-rounded text-info"
                                                href="{{ route('products.list', Crypt::encrypt($brand->id_brands)) }}">
                                                <i class="fa-solid fa-arrow-up-right-from-square"></i> <strong>Products</strong>
                                            </a>
                                        @endcan
                                        @can('Brands edit')
                                            <a class="btn rounded shadow-base" title="Edit Product"
                                            href="{{ route('brand.edit', Crypt::encrypt($brand->id_brands)) }}">
                                            <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                class="text-primary">Edit</span>
                                        </a>

                                        @endcan
                                        @can('Brands delete')
                                        <a class="btn rounded shadow-base" title="Delete Product"
                                        href="{{ route('brand.destroy', ['id' => Crypt::encrypt($brand->id_brands)]) }}">
                                        <i class="text-danger fa-solid fa-trash-can"></i> <span
                                            class="text-danger">Remove</span>
                                    </a>

                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
@endsection

@push('scripts')

<script type="text/javascript">
    $(function() {
        oTable = $('#example2').DataTable({
            dom: 'Bfrtip',
            buttons: [{
                    extend: 'csv',
                    text: 'CSV',
                    title: 'Brands List',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: 'th:not(:last-child)'
                    }
                },
                {
                    extend: 'excel',
                    text: 'Excel',
                    title: 'Brands List',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: 'th:not(:last-child)'
                    }
                },
                {
                    extend: 'pdf',
                    text: 'PDF',
                    title: 'Brands List',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: 'th:not(:last-child)'
                    }
                },
                {
                    extend: 'print',
                    text: 'Print',
                    title: 'Brands List',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: 'th:not(:last-child)'
                    }
                }
            ],
            responsive: !0
        });
    });
</script>
    {{-- <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script> --}}
@endpush
