@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Print {{ $voucherNumber->voucher_type }}</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Print {{ $voucherNumber->voucher_type }}
    </h2>

    <div class="row" id="printableArea">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <h4>
                        <span><strong>Voucher Number #:</strong> {{ $voucherNumber->voucher_number }}</span><br>
                        <span><strong>Voucher Date:</strong>
                            {{ date('d-m-Y', strtotime($voucherNumber->created_at)) }}</span><br>
                        <span><strong>Voucher Type:</strong> {{ $voucherNumber->voucher_type }}</span><br>
                        <span><strong>Business Partner:</strong>
                            {{ $voucherNumber->vouchers->first()->partner_name }}</span><br>
                        <span><strong>Description:</strong> {{ $voucherNumber->vouchers->first()->description }}</span>
                    </h4>
                </div>
                <div class="mt-5">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Account Number</th>
                                <th>Account Title</th>
                                <th>Payment Mode</th>
                                <th>Instrument #</th>
                                <th>Remarks</th>
                                <th>Debit</th>
                                <th>Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($voucherNumber->vouchers as $voucher)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $voucher->account_no }}</td>
                                    <td>{{ $voucher->account_title }}</td>
                                    <td>{{ $voucher->payment_mode }}</td>
                                    <td>{{ $voucher->instrument }}</td>
                                    <td>{{ $voucher->remarks }}</td>
                                    <td>{{ $voucher->debit }}</td>
                                    <td>{{ $voucher->credit }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="float-end">
                        <h5>Total Debit: {{ $voucherNumber->vouchers->sum('debit') }}</h5>
                        <h5>Total Credit: {{ $voucherNumber->vouchers->sum('credit') }}</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printDiv() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }

        window.onload = function() {
            printDiv();
        };
    </script>
@endpush
